/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.annotation;

import java.lang.annotation.Annotation;
import org.fujion.annotation.PackageScanner;
import org.fujion.common.MiscUtil;

public abstract class AbstractClassScanner<T, A extends Annotation> {
    private final PackageScanner packageScanner = new PackageScanner();
    private final Class<T> targetClass;
    private final Class<? extends Annotation> annotationClass;

    protected AbstractClassScanner(Class<T> targetClass, Class<A> annotationClass) {
        this.targetClass = targetClass;
        this.annotationClass = annotationClass;
    }

    public void scanPackage(Package pkg) {
        this.scanPackage(pkg.getName());
    }

    public void scanPackage(String pkgName) {
        for (Class<?> clazz : this.packageScanner.getClasses(pkgName)) {
            this.scanClass(clazz);
        }
    }

    public void scanClass(String className) {
        try {
            this.scanClass(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            throw MiscUtil.toUnchecked((Throwable)e);
        }
    }

    public void scanClass(Class<?> clazz) {
        for (Class<?> innerClass : clazz.getDeclaredClasses()) {
            this.scanClass(innerClass);
        }
        if (!clazz.isAnnotationPresent(this.annotationClass)) {
            return;
        }
        if (!this.targetClass.isAssignableFrom(clazz)) {
            throw new RuntimeException(this.annotationClass.getName() + " annotation only valid on " + this.targetClass.getName() + " subclass");
        }
        this.doScanClass(clazz);
    }

    protected abstract void doScanClass(Class<T> var1);
}

