/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.annotation;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fujion.ancillary.ComponentRegistry;
import org.fujion.annotation.AbstractClassScanner;
import org.fujion.annotation.Component;
import org.fujion.annotation.ComponentDefinition;
import org.fujion.component.BaseComponent;

public class ComponentScanner
extends AbstractClassScanner<BaseComponent, Component> {
    private static final Log log = LogFactory.getLog(ComponentScanner.class);
    private static final ComponentScanner instance = new ComponentScanner();

    public static ComponentScanner getInstance() {
        return instance;
    }

    private ComponentScanner() {
        super(BaseComponent.class, Component.class);
    }

    @Override
    protected void doScanClass(Class<BaseComponent> clazz) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processing @Component annotation for class " + clazz));
        }
        ComponentDefinition def = new ComponentDefinition(clazz);
        this.scanMethods(def, clazz, false);
        this.scanMethods(def, def.getFactoryClass(), true);
        ComponentRegistry.getInstance().register(def);
    }

    private void scanMethods(ComponentDefinition def, Class<?> clazz, boolean factoryMethods) {
        if (clazz == null || clazz == Object.class) {
            return;
        }
        for (Method method : clazz.getDeclaredMethods()) {
            this.processMethod(def, method, factoryMethods);
        }
        for (GenericDeclaration genericDeclaration : clazz.getInterfaces()) {
            this.scanMethods(def, (Class<?>)genericDeclaration, factoryMethods);
        }
        this.scanMethods(def, clazz.getSuperclass(), factoryMethods);
    }

    private void processMethod(ComponentDefinition def, Method method, boolean factoryMethods) {
        method.setAccessible(true);
        if (method.isSynthetic() || method.isBridge()) {
            return;
        }
        if (factoryMethods) {
            def._addFactoryParameter(method);
        } else {
            def._addSetter(method);
            def._addGetter(method);
        }
    }
}

