/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.annotation;

import java.util.Collection;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fujion.ancillary.ConvertUtil;
import org.fujion.ancillary.OptionMap;
import org.fujion.annotation.AbstractFieldScanner;
import org.fujion.annotation.Option;
import org.fujion.expression.ELEvaluator;

public class OptionScanner
extends AbstractFieldScanner<Object, Option> {
    private static final Log log = LogFactory.getLog(OptionScanner.class);
    private static final OptionScanner instance = new OptionScanner();

    public static void scan(Object object, OptionMap map) {
        instance.scan(object, (annotation, field) -> {
            try {
                if (annotation.ignore()) {
                    return true;
                }
                String name = annotation.value();
                name = name.isEmpty() ? field.getName() : name;
                Object value = field.get(object);
                if (value == null) {
                    return true;
                }
                if (value instanceof OptionMap.IOptionMapConverter) {
                    value = ((OptionMap.IOptionMapConverter)value).toMap();
                }
                if (value instanceof Collection && ((Collection)value).isEmpty()) {
                    return true;
                }
                if (value instanceof Map && ((Map)value).isEmpty()) {
                    return true;
                }
                if (annotation.convertTo() != Object.class) {
                    value = ConvertUtil.convert(value, annotation.convertTo());
                }
                if (!annotation.convertUsing().isEmpty()) {
                    value = instance.convertWith(value, annotation.convertUsing());
                }
                instance.setValue(name, value, map);
            }
            catch (Exception e) {
                log.error((Object)"Exception transforming option map.", (Throwable)e);
            }
            return true;
        });
    }

    private OptionScanner() {
        super(Object.class, Option.class);
    }

    private void setValue(String name, Object value, OptionMap map) {
        if (name.contains(".")) {
            String[] pcs = name.split("\\.", 2);
            name = pcs[0];
            String rest = pcs[1];
            if (!rest.isEmpty()) {
                OptionMap submap = (OptionMap)map.get(name);
                OptionMap newmap = submap == null ? new OptionMap() : submap;
                this.setValue(rest, value, newmap);
                if (submap == null && !newmap.isEmpty()) {
                    map.put(name, (Object)newmap);
                }
            }
            return;
        }
        map.put(name, value);
    }

    private Object convertWith(Object value, String expression) {
        if (!expression.contains("${")) {
            expression = "${" + expression + "}";
        }
        return ELEvaluator.getInstance().evaluate(expression, new ValueWrapper(value));
    }

    private static class ValueWrapper {
        private final Object value;

        ValueWrapper(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

