/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.component;

import org.fujion.annotation.Component;
import org.fujion.component.BaseComponent;
import org.fujion.component.BaseUIComponent;
import org.fujion.component.Columns;
import org.fujion.component.Rows;

@Component(tag="grid", widgetModule="fujion-grid", widgetClass="Grid", parentTag={"*"}, childTag={@Component.ChildTag(value="rows", maximum=1), @Component.ChildTag(value="columns", maximum=1)}, description="A grid component.")
public class Grid
extends BaseUIComponent {
    private Columns columns;
    private Rows rows;
    private String title;
    private boolean autoSize = true;

    public Grid() {
        this.addClass("table");
    }

    @Override
    protected void afterAddChild(BaseComponent child) {
        super.afterAddChild(child);
        if (child instanceof Rows) {
            this.rows = (Rows)child;
        }
        if (child instanceof Columns) {
            this.columns = (Columns)child;
        }
    }

    @Override
    protected void afterRemoveChild(BaseComponent child) {
        super.afterRemoveChild(child);
        if (child == this.rows) {
            this.rows = null;
        } else if (child == this.columns) {
            this.columns = null;
        }
    }

    public Columns getColumns() {
        return this.columns;
    }

    public Rows getRows() {
        return this.rows;
    }

    @Component.PropertyGetter(value="title", description="The title text.")
    public String getTitle() {
        return this.title;
    }

    @Component.PropertySetter(value="title", description="The title text.")
    public void setTitle(String title) {
        this.title = this.nullify(title);
        this.propertyChange("title", this.title, this.title, true);
    }

    @Component.PropertyGetter(value="autoSize", description="If true, columns automatically resize based on their content.  Default is true.")
    public boolean getAutoSize() {
        return this.autoSize;
    }

    @Component.PropertySetter(value="autoSize", description="If true, columns automatically resize based on their content.  Default is true.")
    public void setAutoSize(boolean autoSize) {
        this.autoSize = autoSize;
        this.propertyChange("autoSize", this.autoSize, this.autoSize, true);
    }
}

