/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.component;

import org.fujion.ancillary.MimeContent;
import org.fujion.annotation.Component;
import org.fujion.annotation.EventHandler;
import org.fujion.component.BaseUIComponent;
import org.fujion.event.LoadEvent;

@Component(tag="iframe", widgetClass="Iframe", parentTag={"*"}, description="An iframe component.")
public class Iframe
extends BaseUIComponent {
    private String src;
    private String sandbox;

    @Component.PropertyGetter(value="src", description="The URL of the loaded document.")
    public String getSrc() {
        return this.src;
    }

    @Component.PropertySetter(value="src", description="The URL of the loaded document.")
    public void setSrc(String src) {
        this._setSrc(src, true);
    }

    private void _setSrc(String src, boolean notifyClient) {
        this.src = this.nullify(src);
        this.propertyChange("src", this.src, this.src, notifyClient);
    }

    public void setContent(MimeContent content) {
        this.setSrc(content == null ? null : content.getSrc());
    }

    @Override
    public void setContent(String content) {
        this.setContent(content == null ? null : new MimeContent("text/html", content.getBytes()));
    }

    @Component.PropertyGetter(value="sandbox", description="The sandbox setting for the iframe.")
    public String getSandbox() {
        return this.sandbox;
    }

    @Component.PropertySetter(value="sandbox", description="The sandbox setting for the iframe.")
    public void setSandbox(String sandbox) {
        this.sandbox = sandbox;
        this.propertyChange("sandbox", this.sandbox, this.sandbox, true);
    }

    @EventHandler(value={"load"}, syncToClient=false)
    private void _onLoad(LoadEvent event) {
        String src = this.nullify(event.getSrc());
        if (src != null) {
            this._setSrc(src, false);
        }
    }
}

