/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.component;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.fujion.ancillary.ComponentException;
import org.fujion.ancillary.INamespace;
import org.fujion.ancillary.IResponseCallback;
import org.fujion.annotation.Component;
import org.fujion.client.CallbackRegistry;
import org.fujion.client.ClientRequest;
import org.fujion.client.Synchronizer;
import org.fujion.common.WeakMap;
import org.fujion.component.BaseComponent;
import org.fujion.core.WebUtil;
import org.fujion.event.Event;
import org.fujion.event.EventQueue;
import org.fujion.page.PageRegistry;
import org.fujion.servlet.DynamicResourceRegistry;
import org.fujion.websocket.Session;
import org.springframework.core.io.Resource;

@Component(tag="page", widgetClass="Page", content=Component.ContentHandling.AS_CHILD, childTag={@Component.ChildTag(value="*")}, description="The root component of a Fujion Server Page.")
public final class Page
extends BaseComponent
implements INamespace {
    public static final String ID_PREFIX = "_fujion_";
    private static final AtomicInteger uniqueId = new AtomicInteger();
    private Synchronizer synchronizer;
    private Session session;
    private int nextId;
    private final Map<String, BaseComponent> ids = new WeakMap();
    private final EventQueue eventQueue = new EventQueue(this);
    private final Map<String, Object> browserInfo = new HashMap<String, Object>();
    private final CallbackRegistry callbacks = new CallbackRegistry(this);
    private Map<String, String> queryParams;
    private String title;
    private String image;
    private boolean closable = true;
    private final String src;

    public static Page _create(String src) {
        return new Page(src);
    }

    public static void _init(Page page, ClientRequest request, Synchronizer synchronizer) {
        page.synchronizer = synchronizer;
        page.session = request.getSession();
        page.browserInfo.putAll((Map)request.getData());
        page._attach(page);
    }

    public Page() {
        this.src = null;
    }

    private Page(String src) {
        this._setId(ID_PREFIX + Integer.toHexString(uniqueId.incrementAndGet()));
        this.src = src;
        PageRegistry.registerPage(this);
    }

    public Synchronizer getSynchronizer() {
        return this.synchronizer;
    }

    public EventQueue getEventQueue() {
        return this.eventQueue;
    }

    @Override
    public void setParent(BaseComponent parent) {
        throw new ComponentException(this, "Page cannot have a parent", new Object[0]);
    }

    public String getBrowserInfo(String key) {
        Object value = this.browserInfo.get(key);
        return value == null ? null : value.toString();
    }

    public <T> T getBrowserInfo(String key, Class<T> type) {
        return (T)this.browserInfo.get(key);
    }

    public Map<String, Object> getBrowserInfo() {
        return Collections.unmodifiableMap(this.browserInfo);
    }

    public String getQueryParam(String param) {
        return this.getQueryParams().get(param);
    }

    public Map<String, String> getQueryParams() {
        if (this.queryParams == null) {
            String requestUrl = (String)this.browserInfo.get("requestURL");
            int i = requestUrl == null ? -1 : requestUrl.indexOf("?");
            this.queryParams = i >= 0 ? WebUtil.queryStringToMap(requestUrl.substring(i + 1), ",") : Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.queryParams);
    }

    public Session getSession() {
        return this.session;
    }

    public String getSrc() {
        return this.src;
    }

    private String nextComponentId() {
        return this.getId() + "_" + Integer.toHexString(++this.nextId);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        PageRegistry.unregisterPage(this);
        if (this.session != null) {
            this.synchronizer.clear();
            this.eventQueue.clearAll();
            this.callbacks.clear();
            this.session = null;
        }
    }

    void registerComponent(BaseComponent component, boolean register) {
        if (this.getId() == null) {
            return;
        }
        String id = component.getId();
        if (id == null) {
            id = this.nextComponentId();
            component._setId(id);
        }
        if (register) {
            this.ids.put(id, component);
        } else {
            this.ids.remove(id);
        }
        Event event = new Event(register ? "register" : "unregister", (BaseComponent)this, component);
        this.fireEvent(event);
    }

    public void registerResource(String path, Resource resource) {
        DynamicResourceRegistry.getInstance().registerResource(this.getId() + "/" + path, resource);
    }

    public int registerCallback(IResponseCallback<?> callback) {
        return this.callbacks.registerCallback(callback);
    }

    public BaseComponent findById(String id) {
        int i = id.indexOf(45);
        return this.ids.get(i == -1 ? id : id.substring(0, i));
    }

    @Component.PropertyGetter(value="closable", description="True if the browser window may be closed without challenge.")
    public boolean isClosable() {
        return this.closable;
    }

    @Component.PropertySetter(value="closable", defaultValue="true", description="True if the browser window may be closed without challenge.")
    public void setClosable(boolean closable) {
        this.closable = closable;
        this.propertyChange("closable", this.closable, this.closable, true);
    }

    @Component.PropertyGetter(value="title", description="The page title.")
    public String getTitle() {
        return this.title;
    }

    @Component.PropertySetter(value="title", description="The page title.")
    public void setTitle(String title) {
        this.title = this.nullify(title);
        this.propertyChange("title", this.title, this.title, true);
    }

    @Component.PropertyGetter(value="image", description="The URL of the image used for the page icon.")
    public String getImage() {
        return this.image;
    }

    @Component.PropertySetter(value="image", description="The URL of the image used for the page icon.")
    public void setImage(String image) {
        this.image = this.nullify(image);
        this.propertyChange("image", this.image, this.image, true);
    }
}

