/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.component;

import java.util.Iterator;
import org.fujion.annotation.Component;
import org.fujion.annotation.EventHandler;
import org.fujion.component.BaseComponent;
import org.fujion.component.BaseLabeledComponent;
import org.fujion.component.BaseLabeledImageComponent;
import org.fujion.component.Treeview;
import org.fujion.event.ChangeEvent;
import org.fujion.event.Event;
import org.fujion.event.EventUtil;

@Component(tag="treenode", widgetModule="fujion-treeview", widgetClass="Treenode", parentTag={"treeview", "treenode"}, childTag={@Component.ChildTag(value="treenode")}, description="A single node in a tree view.")
public class Treenode
extends BaseLabeledImageComponent<BaseLabeledComponent.LabelPositionNone>
implements Iterable<Treenode> {
    private boolean collapsed;
    private boolean selected;
    private int badgeCounter;

    @Component.PropertyGetter(value="selected", description="The selected state.")
    public boolean isSelected() {
        return this.selected;
    }

    @Component.PropertySetter(value="selected", defaultValue="false", description="The selected state.")
    public void setSelected(boolean selected) {
        this._setSelected(selected, true, true);
    }

    void _setSelected(boolean selected, boolean notifyClient, boolean notifyParent) {
        Treeview treeview;
        this.selected = selected;
        if (this.propertyChange("selected", this.selected, this.selected, notifyClient) && notifyParent && (treeview = this.getTreeview()) != null) {
            if (selected) {
                treeview.setSelectedNode(this);
            } else if (treeview.getSelectedNode() == this) {
                treeview.setSelectedNode(null);
            }
        }
    }

    private void _setTreeSelected(Treenode selectedNode) {
        Treeview treeview = this.getTreeview();
        if (treeview != null) {
            treeview.setSelectedNode(selectedNode);
        }
    }

    public Treeview getTreeview() {
        return this.getAncestor(Treeview.class);
    }

    @Override
    protected void afterAddChild(BaseComponent child) {
        if (((Treenode)child).isSelected()) {
            this._setTreeSelected((Treenode)child);
        }
    }

    @Override
    protected void beforeRemoveChild(BaseComponent child) {
        if (((Treenode)child).isSelected()) {
            this._setTreeSelected(null);
        }
    }

    @Component.PropertyGetter(value="collapsed", description="True if the node is collapsed.")
    public boolean isCollapsed() {
        return this.collapsed;
    }

    @Component.PropertySetter(value="collapsed", defaultValue="false", description="True if the node is collapsed.")
    public void setCollapsed(boolean collapsed) {
        this._setCollapsed(collapsed, true);
    }

    private void _setCollapsed(boolean collapsed, boolean notifyClient) {
        this.collapsed = collapsed;
        this.propertyChange("collapsed", this.collapsed, this.collapsed, notifyClient);
    }

    public void makeVisible() {
        BaseComponent node = this.getParent();
        while (node instanceof Treenode) {
            ((Treenode)node).setCollapsed(false);
            node = node.getParent();
        }
        this.scrollIntoView();
    }

    @EventHandler(value={"toggle"}, syncToClient=false)
    private void _onToggle() {
        this._setCollapsed(!this.collapsed, false);
    }

    @EventHandler(value={"change"}, syncToClient=false)
    private void _onChange(ChangeEvent event) {
        this._setSelected(this.defaultify(event.getValue(Boolean.class), false), false, true);
        Treeview tree = this.getTreeview();
        if (tree != null) {
            event = new ChangeEvent(tree, event.getData(), (Object)this);
            EventUtil.send(event);
        }
    }

    @EventHandler(value={"badge"})
    private void _onBadge(Event event) {
        int delta = (Integer)event.getData();
        if (delta != 0) {
            this.badgeCounter += delta;
            this.sync("badge", this.badgeCounter);
        }
    }

    @Override
    public Iterator<Treenode> iterator() {
        return new TreenodeIterator(this);
    }

    protected static class TreenodeIterator
    implements Iterator<Treenode> {
        private Treenode current;
        private Treenode next;
        private int level;

        public TreenodeIterator(BaseComponent root) {
            this.next = root == null ? null : root.getChild(Treenode.class);
        }

        private Treenode advance() {
            if (this.current == null || this.level < 0) {
                return null;
            }
            this.next = (Treenode)this.current.getFirstChild();
            if (this.next != null) {
                ++this.level;
                return this.next;
            }
            this.next = (Treenode)this.current.getNextSibling();
            if (this.next != null) {
                return this.next;
            }
            this.next = this.current;
            while (--this.level >= 0) {
                BaseComponent parent = this.next.getParent();
                if (!(parent instanceof Treenode)) {
                    this.level = -1;
                    continue;
                }
                this.next = (Treenode)parent.getNextSibling();
                if (this.next != null) break;
                this.next = (Treenode)parent;
            }
            return this.level < 0 ? null : this.next;
        }

        private Treenode nextNode() {
            return this.next == null ? this.advance() : this.next;
        }

        @Override
        public boolean hasNext() {
            return this.nextNode() != null;
        }

        @Override
        public Treenode next() {
            this.current = this.nextNode();
            this.next = null;
            return this.current;
        }
    }
}

