/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.event;

import java.util.LinkedList;
import org.fujion.client.ExecutionContext;
import org.fujion.component.Page;
import org.fujion.event.Event;
import org.fujion.event.EventUtil;
import org.fujion.websocket.Session;

public class EventQueue {
    private final LinkedList<Event> queue = new LinkedList();
    private final Page page;

    public EventQueue(Page page) {
        this.page = page;
    }

    public synchronized void queue(Event event) {
        Session session;
        if (event.getPage() != this.page) {
            throw new RuntimeException("Event does not belong to this queue's page");
        }
        this.queue.add(event);
        if (!(this.queue.size() != 1 || ExecutionContext.isProcessing() && ExecutionContext.getPage() == this.page || (session = this.page.getSession()) == null)) {
            session.ping("flush");
        }
    }

    public synchronized void processAll() {
        while (!this.queue.isEmpty()) {
            Event event;
            EventUtil.send(event, (event = this.queue.removeFirst()).getTarget() == null ? this.page : event.getTarget());
        }
    }

    public synchronized void clearAll() {
        this.queue.clear();
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }
}

