/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.event;

import org.fujion.annotation.EventType;
import org.fujion.component.BaseComponent;
import org.fujion.event.Event;
import org.fujion.event.KeyCode;

public abstract class KeyEvent
extends Event {
    @EventType.EventParameter
    private int keyCode;
    @EventType.EventParameter
    private char charCode;
    @EventType.EventParameter
    private boolean shiftKey;
    @EventType.EventParameter
    private boolean ctrlKey;
    @EventType.EventParameter
    private boolean altKey;
    @EventType.EventParameter
    private boolean metaKey;

    protected KeyEvent(String type) {
        super(type);
    }

    protected KeyEvent(String type, BaseComponent target, Object data) {
        super(type, target, data);
    }

    public boolean isAltKey() {
        return this.altKey;
    }

    public boolean isCtrlKey() {
        return this.ctrlKey;
    }

    public boolean isShiftKey() {
        return this.shiftKey;
    }

    public boolean isMetaKey() {
        return this.metaKey;
    }

    public KeyCode getKeyCode() {
        return KeyCode.fromCode(this.keyCode);
    }

    public char getCharCode() {
        return this.charCode;
    }

    public String getKeycapture() {
        StringBuilder sb = new StringBuilder();
        if (this.isCtrlKey()) {
            sb.append('^');
        }
        if (this.isAltKey()) {
            sb.append('@');
        }
        if (this.isMetaKey()) {
            sb.append('~');
        }
        if (this.isShiftKey()) {
            sb.append('$');
        }
        sb.append("#").append(this.keyCode);
        return sb.toString();
    }
}

