/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.model;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.function.Function;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.reflect.MethodUtils;
import org.fujion.ancillary.ConvertUtil;
import org.fujion.ancillary.DeferredInvocation;
import org.fujion.common.MiscUtil;
import org.fujion.component.BaseComponent;
import org.fujion.event.PropertychangeEvent;
import org.fujion.model.IBinder;
import org.fujion.model.IBinding;
import org.springframework.util.Assert;

public class GenericBinder<M>
implements IBinder<M>,
Observer {
    private M model;
    private List<GenericBinding> readBindings;
    private List<GenericBinding> writeBindings;
    private boolean updating;

    public GenericBinder() {
        this(null);
    }

    public GenericBinder(M model) {
        this.setModel(model);
    }

    @Override
    public M getModel() {
        return this.model;
    }

    @Override
    public void setModel(M model) {
        if (this.model instanceof Observable) {
            ((Observable)this.model).deleteObserver(this);
        }
        this.model = model;
        this.modelChanged(null);
        this.targetChanged(null);
        if (this.model instanceof Observable) {
            ((Observable)this.model).addObserver(this);
        }
    }

    @Override
    public IBinding read(String modelProperty, Function<?, ?> converter) {
        return new ReadBinding(modelProperty, converter);
    }

    @Override
    public IBinding write(String modelProperty, Function<?, ?> converter) {
        return new WriteBinding(modelProperty, converter);
    }

    @Override
    public IBinding dual(String modelProperty, Function<?, ?> readConverter, Function<?, ?> writeConverter) {
        return new DualBinding(modelProperty, readConverter, writeConverter);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o == this.model) {
            this.modelChanged(arg instanceof String ? (String)arg : null);
        }
    }

    public void modelChanged() {
        this.modelChanged(null);
    }

    private void targetChanged(String propertyName) {
        this.processChanged(propertyName, false);
    }

    public void modelChanged(String propertyName) {
        this.processChanged(propertyName, true);
    }

    public Function<?, ?> lambda(Object instance, String methodName, Object ... args) {
        Object[] objectArray;
        int last;
        int n = last = args == null ? 0 : args.length;
        if (args == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = null;
        } else {
            objectArray = Arrays.copyOf(args, last + 1);
        }
        Object[] realArgs = objectArray;
        return arg -> {
            try {
                realArgs[last] = arg;
                return MethodUtils.invokeMethod((Object)instance, (String)methodName, (Object[])realArgs, (Class[])MiscUtil.getParameterTypes((Object[])realArgs));
            }
            catch (Exception e) {
                throw MiscUtil.toUnchecked((Throwable)e);
            }
        };
    }

    public Function<?, ?> choice(Object ... choices) {
        return arg -> {
            int i = this.valueToInt(arg);
            return i < 0 || i >= choices.length ? null : choices[i];
        };
    }

    private int valueToInt(Object value) {
        if (value == null) {
            return -1;
        }
        if (value instanceof Enum) {
            return ((Enum)value).ordinal();
        }
        for (int i = 0; i < 2; ++i) {
            try {
                switch (i) {
                    case 0: {
                        return ConvertUtil.convert(value, Boolean.class) != false ? 0 : 1;
                    }
                    case 1: {
                        return ConvertUtil.convert(value, Integer.class);
                    }
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processChanged(String propertyName, boolean read) {
        List<GenericBinding> bindings;
        List<GenericBinding> list = bindings = read ? this.readBindings : this.writeBindings;
        if (!this.updating && bindings != null) {
            try {
                this.updating = true;
                for (GenericBinding binding : bindings) {
                    if (propertyName != null && !propertyName.equals(binding.modelProperty)) continue;
                    if (read) {
                        binding.read();
                        continue;
                    }
                    binding.write();
                }
            }
            finally {
                this.updating = false;
            }
        }
    }

    private class DualBinding
    extends GenericBinding
    implements IBinding.IReadBinding,
    IBinding.IWriteBinding {
        DualBinding(String modelProperty, Function<?, ?> readConverter, Function<?, ?> writeConverter) {
            super(modelProperty, readConverter, writeConverter);
        }

        @Override
        public void read() {
            ((GenericBinding)this).read();
        }

        @Override
        public void write() {
            ((GenericBinding)this).write();
        }
    }

    private class WriteBinding
    extends GenericBinding
    implements IBinding.IWriteBinding {
        WriteBinding(String modelProperty, Function<?, ?> writeConverter) {
            super(modelProperty, null, writeConverter);
        }

        @Override
        public void write() {
            ((GenericBinding)this).write();
        }
    }

    private class ReadBinding
    extends GenericBinding
    implements IBinding.IReadBinding {
        ReadBinding(String modelProperty, Function<?, ?> readConverter) {
            super(modelProperty, readConverter, null);
        }

        @Override
        public void read() {
            ((GenericBinding)this).read();
        }
    }

    private class GenericBinding
    implements IBinding {
        private final String modelProperty;
        private final Function<?, ?> readConverter;
        private final Function<?, ?> writeConverter;
        private DeferredInvocation<?> getter;
        private DeferredInvocation<?> setter;

        GenericBinding(String modelProperty, Function<?, ?> readConverter, Function<?, ?> writeConverter) {
            this.modelProperty = modelProperty;
            this.readConverter = readConverter;
            this.writeConverter = writeConverter;
        }

        @Override
        public void init(BaseComponent instance, String propertyName, Method getter, Method setter) {
            if (this instanceof IBinding.IReadBinding) {
                Assert.notNull((Object)setter, (String)("Property is not writable: " + propertyName));
                this.setter = this.toDeferred(instance, setter, propertyName, 2);
                GenericBinder.this.readBindings = GenericBinder.this.readBindings == null ? new ArrayList() : GenericBinder.this.readBindings;
                GenericBinder.this.readBindings.add(this);
                this.read();
            } else {
                this.setter = null;
            }
            if (this instanceof IBinding.IWriteBinding) {
                Assert.notNull((Object)getter, (String)("Property is not readable: " + propertyName));
                this.getter = this.toDeferred(instance, getter, propertyName, 1);
                if (!(this instanceof IBinding.IReadBinding)) {
                    GenericBinder.this.writeBindings = GenericBinder.this.writeBindings == null ? new ArrayList() : GenericBinder.this.writeBindings;
                    GenericBinder.this.writeBindings.add(this);
                    this.write();
                }
                instance.addEventListener(PropertychangeEvent.class, event -> {
                    if (!GenericBinder.this.updating && ((PropertychangeEvent)event).getPropertyName().equals(propertyName)) {
                        this.write();
                    }
                });
            } else {
                this.getter = null;
            }
        }

        private DeferredInvocation<?> toDeferred(BaseComponent instance, Method method, String name, int maxArgs) {
            DeferredInvocation deferredInvocation;
            if (method == null) {
                deferredInvocation = null;
            } else {
                Object[] objectArray;
                if (method.getParameterCount() == maxArgs) {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = name;
                } else {
                    objectArray = null;
                }
                deferredInvocation = new DeferredInvocation(instance, method, objectArray);
            }
            return deferredInvocation;
        }

        private void read() {
            try {
                if (GenericBinder.this.model != null) {
                    Object value = PropertyUtils.getProperty((Object)GenericBinder.this.model, (String)this.modelProperty);
                    if ((value = this.convert(this.readConverter, value)) != IBinder.NOVALUE) {
                        this.setter.invoke(value);
                    }
                }
            }
            catch (Exception e) {
                throw MiscUtil.toUnchecked((Throwable)e);
            }
        }

        private void write() {
            try {
                Object value;
                if (GenericBinder.this.model != null && (value = this.convert(this.writeConverter, this.getter.invoke(new Object[0]))) != IBinder.NOVALUE) {
                    Class<?> targetType = PropertyUtils.getPropertyDescriptor((Object)GenericBinder.this.model, (String)this.modelProperty).getPropertyType();
                    value = ConvertUtil.convert(value, targetType);
                    BeanUtils.copyProperty((Object)GenericBinder.this.model, (String)this.modelProperty, (Object)value);
                }
            }
            catch (Exception e) {
                throw MiscUtil.toUnchecked((Throwable)e);
            }
        }

        private Object convert(Function<?, ?> converter, Object value) {
            return converter == null ? value : converter.apply(value);
        }
    }
}

