/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.fujion.common.MiscUtil;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;

class DynamicResource
extends AbstractResource {
    private final Resource resource;
    private final String filename;
    private final File file;

    public DynamicResource(String filename, Resource resource) {
        this.filename = filename;
        this.resource = resource;
        this.file = this.createDummyFile();
    }

    private File createDummyFile() {
        try {
            return File.createTempFile("fujion", "." + FilenameUtils.getExtension((String)this.filename));
        }
        catch (IOException e) {
            throw MiscUtil.toUnchecked((Throwable)e);
        }
    }

    public File getFile() {
        return this.file;
    }

    public String getFilename() {
        return this.filename;
    }

    public URL getURL() throws IOException {
        return this.file.toURI().toURL();
    }

    public String getDescription() {
        return this.resource.getDescription();
    }

    public InputStream getInputStream() throws IOException {
        return this.resource.getInputStream();
    }

    public long contentLength() throws IOException {
        return this.resource.contentLength();
    }

    protected void finalize() throws Throwable {
        FileUtils.deleteQuietly((File)this.file);
        super.finalize();
    }
}

