/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.servlet;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.fujion.component.Page;
import org.fujion.page.PageRegistry;
import org.fujion.servlet.DynamicResource;
import org.fujion.websocket.ISessionLifecycle;
import org.fujion.websocket.Session;
import org.fujion.websocket.Sessions;
import org.springframework.core.io.Resource;

public class DynamicResourceRegistry
implements ISessionLifecycle {
    private static DynamicResourceRegistry instance = new DynamicResourceRegistry();
    private final Map<String, ResourceRegistry> registryMap = new ConcurrentHashMap<String, ResourceRegistry>();
    private final Pattern sessionPattern = Pattern.compile("^_fujion_\\d+\\/.*$");

    public static DynamicResourceRegistry getInstance() {
        return instance;
    }

    private DynamicResourceRegistry() {
        this.getRegistry("", true);
        Sessions.getInstance().addLifecycleListener(this);
    }

    public Resource getResource(String path) {
        ResourceRegistry registry = this.getRegistry(path, false);
        String name = registry == null ? null : this.extractFromPath(path, false);
        return registry == null || name == null ? null : (Resource)registry.get(name);
    }

    public void registerResource(String path, Resource resource) {
        ResourceRegistry registry = this.getRegistry(path, resource != null);
        String name = this.extractFromPath(path, false);
        Object object = resource == null || name == null ? null : (resource = resource.getFilename() == null ? new DynamicResource(name, resource) : resource);
        if (registry != null && name != null) {
            if (resource == null) {
                registry.remove(name);
            } else {
                registry.put(name, resource);
            }
        }
    }

    private String extractFromPath(String path, boolean pageId) {
        String part;
        if (this.sessionPattern.matcher(path).matches()) {
            int i = path.indexOf("/");
            part = pageId ? path.substring(0, i) : StringUtils.substring((String)path, (int)(i + 1));
        } else {
            part = pageId ? null : path;
        }
        return StringUtils.trimToNull((String)part);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceRegistry getRegistry(String path, boolean autoCreate) {
        Map<String, ResourceRegistry> map = this.registryMap;
        synchronized (map) {
            String key = this.extractFromPath(path, true);
            if (key != null) {
                autoCreate &= PageRegistry.hasPage(key);
            } else {
                key = "";
            }
            ResourceRegistry registry = this.registryMap.get(key);
            if (registry == null && autoCreate) {
                registry = new ResourceRegistry();
                this.registryMap.put(key, registry);
            }
            return registry;
        }
    }

    @Override
    public void onSessionCreate(Session session) {
    }

    @Override
    public void onSessionDestroy(Session session) {
        Page page = session.getPage();
        String pid = page == null ? "?" : page.getId();
        ResourceRegistry registry = this.registryMap.get(pid);
        if (registry != null) {
            this.registryMap.remove(pid);
            registry.clear();
        }
    }

    private static class ResourceRegistry
    extends ConcurrentHashMap<String, Resource> {
        private static final long serialVersionUID = 1L;

        private ResourceRegistry() {
        }
    }
}

