/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.fujion.common.MiscUtil;
import org.fujion.component.Page;
import org.fujion.core.RequestUtil;
import org.fujion.core.WebUtil;
import org.fujion.logging.LogUtil;
import org.fujion.webjar.WebJarLocator;
import org.fujion.websocket.WebSocketConfiguration;
import org.springframework.core.io.AbstractFileResolvingResource;
import org.springframework.core.io.Resource;
import org.springframework.web.servlet.resource.ResourceTransformerChain;
import org.springframework.web.servlet.resource.ResourceTransformerSupport;

public class FujionResourceTransformer
extends ResourceTransformerSupport {
    private final List<String> bootstrapperTemplate;

    public FujionResourceTransformer() {
        try {
            this.bootstrapperTemplate = IOUtils.readLines((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/org/fujion/bootstrapper.htm"), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw MiscUtil.toUnchecked((Throwable)e);
        }
    }

    public Resource transform(HttpServletRequest request, Resource resource, ResourceTransformerChain chain) throws IOException {
        String filename;
        String string = filename = resource == null ? null : resource.getFilename();
        if (filename == null || !filename.endsWith(".fsp")) {
            return chain.transform(request, resource);
        }
        request.getSession(true);
        BootstrapperResource bootstrapperResource = new BootstrapperResource(resource);
        HashMap<String, Object> map = new HashMap<String, Object>();
        Page page = Page._create(resource.getURL().toString());
        String baseUrl = RequestUtil.getBaseURL(request);
        String wsUrl = "ws" + baseUrl.substring(4) + "ws";
        String webJarInit = WebJarLocator.getInstance().getWebJarInit();
        map.put("pid", page.getId());
        map.put("baseUrl", baseUrl);
        map.put("wsUrl", wsUrl);
        map.put("webjarInit", webJarInit);
        map.put("debug", WebUtil.isDebugEnabled());
        map.put("logging", LogUtil.getSettingsForClient());
        map.put("keepalive", WebSocketConfiguration.getKeepaliveInterval());
        StrSubstitutor sub = new StrSubstitutor(map);
        for (String line : this.bootstrapperTemplate) {
            bootstrapperResource.addContent(sub.replace(line));
        }
        return chain.transform(request, (Resource)bootstrapperResource);
    }

    private static class BootstrapperResource
    extends AbstractFileResolvingResource {
        private final Resource resource;
        private final StringBuffer content = new StringBuffer();

        BootstrapperResource(Resource resource) {
            this.resource = resource;
        }

        public void addContent(String data) {
            this.content.append(data).append('\n');
        }

        public long contentLength() throws IOException {
            return this.content.length();
        }

        public String getFilename() {
            return this.resource.getFilename();
        }

        public URL getURL() throws IOException {
            return this.resource.getURL();
        }

        public String getDescription() {
            return this.resource.getDescription();
        }

        public InputStream getInputStream() throws IOException {
            return IOUtils.toInputStream((String)this.content.toString(), (Charset)StandardCharsets.UTF_8);
        }
    }
}

