/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.theme;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fujion.theme.Theme;
import org.fujion.theme.ThemeRegistry;
import org.fujion.theme.ThemeResolvers;
import org.springframework.web.servlet.ThemeResolver;

public class ThemeServletFilter
implements Filter {
    private final ThemeResolver themeResolver = ThemeResolvers.getInstance();

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String requestPath;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String themeName = this.themeResolver.resolveThemeName(httpRequest);
        Theme theme = (Theme)ThemeRegistry.getInstance().get(themeName);
        if (theme != null && (requestPath = theme.translatePath(httpRequest.getPathInfo())) != null) {
            httpResponse.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
            httpResponse.setHeader("Pragma", "no-cache");
            httpResponse.setDateHeader("Expires", 0L);
            if (!requestPath.isEmpty()) {
                httpRequest.getRequestDispatcher(requestPath).forward((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                return;
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

