/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.ancillary;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.fujion.ancillary.ComponentException;
import org.fujion.ancillary.ConvertUtil;
import org.fujion.annotation.Component;
import org.fujion.annotation.ComponentDefinition;
import org.fujion.common.MiscUtil;
import org.fujion.component.BaseComponent;
import org.fujion.expression.ELEvaluator;

public class ComponentFactory {
    private final ComponentDefinition def;
    private Class<? extends BaseComponent> clazz;
    private boolean active = true;
    private Iterable<?> forEach;
    private String forVar = "each";

    public ComponentFactory(ComponentDefinition def) {
        this.def = def;
        this.clazz = def.getComponentClass();
    }

    @Component.FactoryParameter(value="impl", description="Component implementation class to substitute.")
    protected void setImplementationClass(Class<? extends BaseComponent> clazz) {
        Class<? extends BaseComponent> originalClazz = this.def.getComponentClass();
        if (clazz != null && !originalClazz.isAssignableFrom(clazz)) {
            throw new ComponentException("Implementation class must extend class " + originalClazz.getName(), new Object[0]);
        }
        this.clazz = clazz;
    }

    @Component.FactoryParameter(value="if", description="If false, prevent component creation.")
    protected void setIf(boolean condition) {
        this.active &= condition;
    }

    @Component.FactoryParameter(value="unless", description="If true, prevent component creation.")
    protected void setUnless(boolean condition) {
        this.active &= !condition;
    }

    @Component.FactoryParameter(value="foreach", description="Specifies a collection for iterative component creation.")
    protected void setForEach(Object forEach) {
        this.forEach = ConvertUtil.convertToIterable(forEach);
    }

    @Component.FactoryParameter(value="forvar", defaultValue="each", description="Specifies the attribute name used in foreach.")
    protected void setForVar(String forVar) {
        String string = forVar = (forVar = StringUtils.trimToNull((String)forVar)) == null ? "each" : forVar;
        if (!BaseComponent.validateName(forVar)) {
            throw new ComponentException("Name specified in 'forvar' is not valid: " + forVar, new Object[0]);
        }
        this.forVar = forVar;
    }

    public List<BaseComponent> create(Map<String, String> attributes) {
        if (attributes != null) {
            for (Map.Entry<String, Method> entry : this.def.getFactoryParameters().entrySet()) {
                String name = entry.getKey();
                if (!attributes.containsKey(name)) continue;
                Object value = ELEvaluator.getInstance().evaluate(attributes.remove(name));
                ConvertUtil.invokeMethod(this, entry.getValue(), value);
            }
        }
        if (!this.active) {
            return Collections.emptyList();
        }
        if (this.forEach == null) {
            return Collections.singletonList(this.create());
        }
        ArrayList<BaseComponent> components = new ArrayList<BaseComponent>();
        for (Object each : this.forEach) {
            BaseComponent comp = this.create();
            comp.setAttribute(this.forVar, each);
            components.add(comp);
        }
        return components;
    }

    private BaseComponent create() {
        try {
            return this.clazz.newInstance();
        }
        catch (Exception e) {
            throw MiscUtil.toUnchecked((Throwable)e);
        }
    }
}

