/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.function.BiFunction;

public abstract class AbstractFieldScanner<T, A extends Annotation> {
    private final Class<T> instanceClass;
    private final Class<A> annotationClass;

    protected AbstractFieldScanner(Class<T> instanceClass, Class<A> annotationClass) {
        this.instanceClass = instanceClass;
        this.annotationClass = annotationClass;
    }

    public void scan(T instance, BiFunction<A, Field, Boolean> processor) {
        if (instance != null) {
            this.scan(instance, processor, instance.getClass());
        }
    }

    private boolean scan(T instance, BiFunction<A, Field, Boolean> processor, Class<?> clazz) {
        if (clazz != Object.class && this.instanceClass.isAssignableFrom(clazz)) {
            if (!this.scan(instance, processor, clazz.getSuperclass())) {
                return false;
            }
            for (Field field : clazz.getDeclaredFields()) {
                Annotation[] annotations;
                field.setAccessible(true);
                for (Annotation annotation : annotations = field.getAnnotationsByType(this.annotationClass)) {
                    if (processor.apply(annotation, field).booleanValue()) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

