/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.annotation;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fujion.ancillary.ComponentRegistry;
import org.fujion.annotation.AbstractClassScanner;
import org.fujion.annotation.Component;
import org.fujion.annotation.ComponentDefinition;
import org.fujion.annotation.MethodScanner;
import org.fujion.component.BaseComponent;

public class ComponentScanner
extends AbstractClassScanner<BaseComponent, Component> {
    private static final Log log = LogFactory.getLog(ComponentScanner.class);
    private static final ComponentScanner instance = new ComponentScanner();

    public static ComponentScanner getInstance() {
        return instance;
    }

    private ComponentScanner() {
        super(BaseComponent.class, Component.class);
    }

    @Override
    protected void doScanClass(Class<BaseComponent> clazz) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processing @Component annotation for class " + clazz));
        }
        ComponentDefinition def = new ComponentDefinition(clazz);
        MethodScanner.scan(clazz, method -> {
            def._addSetter(method);
            def._addGetter(method);
        });
        MethodScanner.scan(def.getFactoryClass(), method -> def._addFactoryParameter(method));
        ComponentRegistry.getInstance().register(def);
    }
}

