/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.reflect.FieldUtils;
import org.fujion.ancillary.ComponentException;
import org.fujion.annotation.EventHandler;
import org.fujion.annotation.MethodScanner;
import org.fujion.annotation.OnFailure;
import org.fujion.common.MiscUtil;
import org.fujion.component.BaseComponent;
import org.fujion.event.Event;
import org.fujion.event.EventUtil;
import org.fujion.event.IEventListener;
import org.springframework.util.ReflectionUtils;

public class EventHandlerScanner {
    public static void wire(Object instance, BaseComponent root) {
        EventHandlerScanner.wire(instance, root, instance.getClass());
    }

    public static void wire(Object instance, BaseComponent component, Map<String, String> onHandlers) {
        for (Map.Entry<String, String> entry : onHandlers.entrySet()) {
            String eventType = entry.getKey();
            String methodName = entry.getValue();
            Class<? extends Event> eventClass = EventUtil.getEventClass(eventType);
            Method handler = ReflectionUtils.findMethod(instance.getClass(), (String)methodName, (Class[])new Class[]{eventClass});
            Method method = handler = handler == null ? ReflectionUtils.findMethod(instance.getClass(), (String)methodName) : handler;
            if (handler == null) {
                throw new ComponentException("A suitable event handler named \"" + methodName + "\"could not be found", new Object[0]);
            }
            EventListener eventListener = new EventListener(instance, handler);
            component.addEventListener(eventType, (IEventListener)eventListener);
        }
    }

    private static void wire(Object instance, BaseComponent root, Class<?> clazz) {
        MethodScanner.scan(clazz, method -> {
            EventHandler[] annotations;
            for (EventHandler annot : annotations = (EventHandler[])method.getAnnotationsByType(EventHandler.class)) {
                OnFailure onFailure = annot.onFailure();
                if (!EventHandlerScanner.validateSignature(method)) {
                    onFailure.doAction("Signature for method \"%s\" does not conform to that required of an event handler", method.getName());
                    break;
                }
                Set<String> targets = EventHandlerScanner.asSet(annot.target());
                Set<String> types = EventHandlerScanner.asSet(annot.value());
                BaseComponent component = null;
                if (types.isEmpty()) {
                    onFailure.doAction("At least one event type must be specified", new Object[0]);
                }
                if (targets.isEmpty()) {
                    targets.add("self");
                }
                for (String target : targets) {
                    if ("self".equals(target)) {
                        component = EventHandlerScanner.isComponent(clazz) ? (BaseComponent)instance : root;
                    } else if (target.startsWith("@")) {
                        String[] fld = target.substring(1).split("\\.", 2);
                        Field field = EventHandlerScanner.findField(clazz, fld[0]);
                        if (field != null) {
                            try {
                                field.setAccessible(true);
                                Object value = field.get(instance);
                                if (value != null && fld.length == 2) {
                                    value = PropertyUtils.getProperty((Object)value, (String)fld[1]);
                                }
                                component = (BaseComponent)value;
                            }
                            catch (Exception e) {
                                onFailure.doAction(e);
                            }
                        }
                    } else {
                        BaseComponent baseComponent = component = root == null ? null : root.findByName(target);
                    }
                    if (component == null) {
                        onFailure.doAction("No suitable event handler target found for \"%s\"", target);
                        continue;
                    }
                    for (String type : types) {
                        component.addEventListener(type, (IEventListener)new EventListener(instance, method), annot.syncToClient());
                    }
                }
            }
        });
    }

    private static boolean validateSignature(Method method) {
        Class<?>[] params = method.getParameterTypes();
        return params.length == 0 || params.length == 1 && Event.class.isAssignableFrom(params[0]);
    }

    private static Set<String> asSet(String[] values) {
        HashSet<String> set = new HashSet<String>();
        for (String value : values) {
            if (value.isEmpty()) continue;
            set.add(value);
        }
        return set;
    }

    private static boolean isComponent(Class<?> clazz) {
        return BaseComponent.class.isAssignableFrom(clazz);
    }

    private static Field findField(Class<?> clazz, String name) {
        try {
            Field result = FieldUtils.getField(clazz, (String)name, (boolean)true);
            return EventHandlerScanner.isComponent(result.getType()) ? result : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private EventHandlerScanner() {
    }

    private static class EventListener
    implements IEventListener {
        private final Object target;
        private final Method method;

        EventListener(Object target, Method method) {
            this.target = target;
            this.method = method;
        }

        @Override
        public void onEvent(Event event) {
            try {
                if (this.method.getParameterTypes().length == 0) {
                    this.method.invoke(this.target, new Object[0]);
                } else {
                    this.method.invoke(this.target, event);
                }
            }
            catch (Throwable e) {
                throw MiscUtil.toUnchecked((Throwable)e);
            }
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof EventListener)) {
                return false;
            }
            EventListener el = (EventListener)object;
            return this.target == el.target && this.method.equals(el.method);
        }

        public int hashCode() {
            return this.target.hashCode() ^ this.method.hashCode();
        }
    }
}

