/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.client;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fujion.ancillary.IResponseCallback;
import org.fujion.component.Page;
import org.fujion.event.CallbackEvent;
import org.fujion.event.ITypedEventListener;

public class CallbackRegistry {
    private static final Log log = LogFactory.getLog(CallbackRegistry.class);
    private static final long HALF_HOUR = 1800000L;
    private final Map<Integer, IResponseCallback<?>> callbacks = Collections.synchronizedMap(new HashMap());
    private final Map<Integer, Long> timestamps = Collections.synchronizedSortedMap(new TreeMap());
    private final AtomicInteger callbackId = new AtomicInteger();
    private final long evictionInterval;
    private final ITypedEventListener<CallbackEvent> callbackListener = event -> this.invokeCallback(event.getHandle(), event.getData());

    public CallbackRegistry(Page page) {
        this(page, 1800000L);
    }

    public CallbackRegistry(Page page, long evictionInterval) {
        this.evictionInterval = evictionInterval;
        page.addEventListener(CallbackEvent.class, this.callbackListener);
    }

    public int registerCallback(IResponseCallback<?> callback) {
        int handle = this.callbackId.incrementAndGet();
        this.callbacks.put(handle, callback);
        this.timestamps.put(handle, System.currentTimeMillis());
        return handle;
    }

    private IResponseCallback<?> unregisterCallback(int handle) {
        this.timestamps.remove(handle);
        IResponseCallback<?> callback = this.callbacks.remove(handle);
        this.evict();
        return callback;
    }

    private void invokeCallback(int handle, Object response) {
        IResponseCallback<?> callback = this.unregisterCallback(handle);
        if (callback != null) {
            try {
                callback.onComplete(response);
            }
            catch (Exception e) {
                log.error((Object)"Exception on client callback", (Throwable)e);
            }
        }
    }

    public void clear() {
        this.callbacks.clear();
        this.timestamps.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evict() {
        long threshold = System.currentTimeMillis() - this.evictionInterval;
        Map<Integer, Long> map = this.timestamps;
        synchronized (map) {
            Map.Entry<Integer, Long> entry;
            Iterator<Map.Entry<Integer, Long>> iter = this.timestamps.entrySet().iterator();
            while (iter.hasNext() && (entry = iter.next()).getValue() < threshold) {
                iter.remove();
                this.callbacks.remove(entry.getKey());
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("Evicted expired callback #" + entry.getKey()));
            }
        }
    }
}

