/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.client;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.fujion.ancillary.IElementIdentifier;
import org.fujion.ancillary.IResponseCallback;
import org.fujion.ancillary.OptionMap;
import org.fujion.client.IClientTransform;
import org.fujion.component.Page;
import org.springframework.util.ClassUtils;

public class ClientInvocation {
    private final String function;
    private final IElementIdentifier target;
    private final IResponseCallback<?> callback;
    private final Object[] arguments;
    private final String key;

    public ClientInvocation(String function, IResponseCallback<?> callback, Object ... arguments) {
        this((IElementIdentifier)null, function, callback, arguments);
    }

    public ClientInvocation(IElementIdentifier target, String function, IResponseCallback<?> callback, Object ... arguments) {
        this.target = target;
        this.arguments = arguments;
        this.callback = callback;
        String[] pcs = function.split("\\^", 2);
        String string = this.function = pcs.length == 1 ? pcs[0] : pcs[1];
        this.key = pcs.length == 1 ? null : (pcs[0].isEmpty() ? pcs[1] : pcs[0]);
    }

    public ClientInvocation(String moduleName, String function, IResponseCallback<?> callback, Object ... arguments) {
        this(moduleName == null ? null : () -> "@" + moduleName, function, callback, arguments);
    }

    public String getKey() {
        return this.key == null ? "" + this.hashCode() : (this.target == null ? this.key : this.key + "^" + this.target.hashCode());
    }

    public OptionMap toMap(Page page) {
        OptionMap data = new OptionMap();
        data.put("fcn", (Object)this.function);
        data.put("tgt", (Object)(this.target == null ? null : this.target.getId()));
        data.put("arg", (Object)this.transformArray(this.arguments, false));
        data.put("cbk", (Object)(this.callback == null ? null : Integer.valueOf(page.registerCallback(this.callback))));
        return data;
    }

    private Object transform(Object source) {
        while (source instanceof IClientTransform) {
            source = ((IClientTransform)source).transformForClient();
        }
        if (source == null || this.ignore(source.getClass())) {
            return source;
        }
        if (source.getClass().isEnum()) {
            return source.toString();
        }
        if (source.getClass().isArray()) {
            return this.transformArray((Object[])source, true);
        }
        if (source instanceof Map) {
            return this.transformMap((Map)source);
        }
        if (source instanceof Collection) {
            return this.transformArray(((Collection)source).toArray(), false);
        }
        if (source instanceof Date) {
            return ((Date)source).getTime();
        }
        return source;
    }

    private boolean ignore(Class<?> clazz) {
        Class<?> cclass = clazz.getComponentType();
        return clazz == String.class || ClassUtils.isPrimitiveOrWrapper(clazz) || cclass != null && this.ignore(cclass);
    }

    private Object[] transformArray(Object[] source, boolean copy) {
        Object[] dest = copy ? new Object[source.length] : source;
        for (int i = 0; i < source.length; ++i) {
            dest[i] = this.transform(source[i]);
        }
        return dest;
    }

    private Object transformMap(Map<Object, Object> source) {
        HashMap dest = new HashMap();
        source.forEach((key, value) -> dest.put(key, this.transform(value)));
        return dest;
    }
}

