/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.component;

import org.fujion.annotation.Component;
import org.fujion.component.BaseLabeledComponent;

@Component(tag="caption", widgetClass="Caption", parentTag={"*"}, childTag={@Component.ChildTag(value="*")}, description="Associates a label with another component.")
public class Caption
extends BaseLabeledComponent<BaseLabeledComponent.LabelPositionAll> {
    private LabelAlignment alignment = LabelAlignment.START;
    private String labelStyle;
    private String labelClass = "label-default";

    public Caption() {
        this(null);
    }

    public Caption(String label) {
        super(label);
        this.setPosition(BaseLabeledComponent.LabelPositionAll.LEFT);
    }

    @Override
    @Component.PropertyGetter(value="position", description="The position of the label relative to its associated component.")
    public BaseLabeledComponent.LabelPositionAll getPosition() {
        return (BaseLabeledComponent.LabelPositionAll)super.getPosition();
    }

    @Override
    @Component.PropertySetter(value="position", defaultValue="left", description="The position of the label relative to its associated component.")
    public void setPosition(BaseLabeledComponent.LabelPositionAll position) {
        super.setPosition(position);
    }

    @Component.PropertyGetter(value="alignment", description="The alignment of the label.")
    public LabelAlignment getAlignment() {
        return this.alignment;
    }

    @Component.PropertySetter(value="alignment", defaultValue="start", description="The alignment of the label.")
    public void setAlignment(LabelAlignment alignment) {
        this.alignment = this.defaultify(alignment, LabelAlignment.START);
        this.propertyChange("alignment", (Object)this.alignment, (Object)this.alignment, true);
    }

    @Component.PropertyGetter(value="labelStyle", description="The CSS style(s) associated with the label.")
    public String getLabelStyle() {
        return this.labelStyle;
    }

    @Component.PropertySetter(value="labelStyle", description="The CSS style(s) associated with the label.")
    public void setLabelStyle(String labelStyle) {
        this.labelStyle = this.trimify(labelStyle);
        this.propertyChange("labelStyle", this.labelStyle, this.labelStyle, true);
    }

    @Component.PropertyGetter(value="labelClass", description="The CSS class(es) associated with the label.")
    public String getLabelClass() {
        return this.labelClass;
    }

    @Component.PropertySetter(value="labelClass", defaultValue="label-default", description="The CSS class(es) associated with the label.")
    public void setLabelClass(String labelClass) {
        this.labelClass = this.trimify(labelClass);
        this.propertyChange("labelClass", this.labelClass, this.labelClass, true);
    }

    public static enum LabelAlignment {
        START,
        CENTER,
        END;

    }
}

