/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.component;

import java.util.Comparator;
import org.fujion.annotation.Component;
import org.fujion.annotation.EventHandler;
import org.fujion.component.BaseLabeledComponent;
import org.fujion.component.BaseLabeledImageComponent;
import org.fujion.component.Columns;
import org.fujion.component.Grid;
import org.fujion.component.Rows;
import org.fujion.model.IListModel;
import org.fujion.model.SmartComparator;
import org.fujion.model.Sorting;

@Component(tag="column", widgetClass="Column", widgetModule="fujion-grid", parentTag={"columns"}, childTag={@Component.ChildTag(value="*")}, description="A single column within a grid.")
public class Column
extends BaseLabeledImageComponent<BaseLabeledComponent.LabelPositionNone> {
    private Comparator<?> sortComparator;
    private Sorting.SortOrder sortOrder = Sorting.SortOrder.UNSORTED;
    private Sorting.SortToggle sortToggle;
    private boolean sortColumn;
    private boolean sizable;

    public Column() {
    }

    public Column(String label) {
        super(label);
    }

    public Comparator<?> getSortComparator() {
        return this.sortComparator;
    }

    public void setSortComparator(Comparator<?> sortComparator) {
        if (sortComparator != this.sortComparator) {
            this.sortComparator = sortComparator;
            this.sortOrder = Sorting.SortOrder.UNSORTED;
            this.updateClient();
        }
    }

    @Component.PropertySetter(value="sortBy", description="The name of the model property to be used for sorting.")
    public void setSortComparator(String propertyName) {
        this.setSortComparator(new SmartComparator(propertyName));
    }

    @Component.PropertyGetter(value="sortOrder", description="The ordering to be used when the sort method is invoked.")
    public Sorting.SortOrder getSortOrder() {
        return this.sortOrder;
    }

    @Component.PropertySetter(value="sortOrder", defaultValue="unsorted", description="The ordering to be used when the sort method is invoked.")
    public void setSortOrder(Sorting.SortOrder sortOrder) {
        this.sortOrder = sortOrder = sortOrder == null ? Sorting.SortOrder.UNSORTED : sortOrder;
        this.propertyChange("sortOrder", (Object)this.sortOrder, (Object)this.sortOrder, false);
    }

    @Component.PropertyGetter(value="sortToggle", description="The type of sort toggle.")
    public Sorting.SortToggle getSortToggle() {
        return this.sortToggle;
    }

    @Component.PropertySetter(value="sortToggle", description="The type of sort toggle.")
    public void setSortToggle(Sorting.SortToggle sortToggle) {
        this.sortToggle = sortToggle;
        this.propertyChange("sortToggle", (Object)this.sortToggle, (Object)this.sortToggle, false);
    }

    @Component.PropertyGetter(value="sizable", description="If true, the column may be resized.")
    public boolean isSizable() {
        return this.sizable;
    }

    @Component.PropertySetter(value="sizable", description="If true, the column may be resized.")
    public void setSizable(boolean sizable) {
        this.sizable = sizable;
        this.propertyChange("sizable", this.sizable, this.sizable, true);
    }

    public void toggleSort() {
        int i = this.sortOrder.ordinal() + 1;
        int max = this.sortToggle == Sorting.SortToggle.TRISTATE ? 3 : 2;
        this.setSortOrder(Sorting.SortOrder.values()[i >= max ? 0 : i]);
        this.sort();
    }

    public void sort() {
        if (!this.sortColumn) {
            this.setSortColumn(true);
            return;
        }
        IListModel<Object> model = this.sortComparator == null || this.sortOrder == Sorting.SortOrder.UNSORTED ? null : this.getRowsModel();
        this.updateClient();
        if (model != null) {
            Comparator<?> comparator = this.sortOrder == Sorting.SortOrder.NATIVE ? null : this.sortComparator;
            model.sort(comparator, this.sortOrder != Sorting.SortOrder.DESCENDING);
        }
    }

    private IListModel<Object> getRowsModel() {
        Grid grid = this.getAncestor(Grid.class);
        Rows rows = grid == null ? null : grid.getRows();
        return rows == null ? null : rows.getModel(Object.class);
    }

    @EventHandler(value={"sort"}, syncToClient=false)
    private void _sort() {
        this.toggleSort();
    }

    @Component.PropertyGetter(value="sortColumn", description="True if this is the currently sorted column.")
    public boolean isSortColumn() {
        return this.sortColumn;
    }

    @Component.PropertySetter(value="sortColumn", defaultValue="false", description="True if this is the currently sorted column.")
    public void setSortColumn(boolean sortColumn) {
        this._setSortColumn(sortColumn, true);
    }

    protected void _setSortColumn(boolean sortColumn, boolean notifyParent) {
        this.sortColumn = sortColumn;
        if (this.propertyChange("sortColumn", this.sortColumn, this.sortColumn, false)) {
            Columns parent;
            if (sortColumn) {
                this.sort();
            } else {
                this.updateClient();
            }
            if (notifyParent && (parent = (Columns)this.getParent()) != null) {
                if (sortColumn) {
                    parent.setSortColumn(this);
                } else if (parent.getSortColumn() == this) {
                    parent.setSortColumn(null);
                }
            }
        }
    }

    private void updateClient() {
        this.sync("sortOrder", (Object)(this.sortComparator == null ? null : (this.sortColumn ? this.sortOrder : Sorting.SortOrder.UNSORTED)));
    }
}

