/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.component;

import org.fujion.annotation.Component;
import org.fujion.component.BaseInputboxComponent;
import org.springframework.util.Assert;

@Component(tag="memobox", widgetClass="Memobox", parentTag={"*"}, description="Component for entering multiple lines of text.")
public class Memobox
extends BaseInputboxComponent<String> {
    private boolean autoScroll;
    private WrapMode wrap = WrapMode.SOFT;
    private int rows = 2;
    private int cols = 20;

    public Memobox() {
        this.addStyle("resize", "none");
    }

    @Override
    @Component.PropertyGetter(value="synchronized", description="A true value means that the client will notify the server as the value of the input box changes. A false value means that the client will notify server of the new value only when the input element loses focus.")
    public boolean getSynchronized() {
        return super.getSynchronized();
    }

    @Override
    @Component.PropertySetter(value="synchronized", defaultValue="false", description="A true value means that the client will notify the server as the value of the input box changes. A false value means that the client will notify server of the new value only when the input element loses focus.")
    public void setSynchronized(boolean synchronize) {
        super.setSynchronized(synchronize);
    }

    @Component.PropertyGetter(value="autoScroll", description="If true, the control will ensure that the last line of input is always visible, scrolling if necessary.")
    public boolean isAutoScroll() {
        return this.autoScroll;
    }

    @Component.PropertySetter(value="autoScroll", defaultValue="false", description="If true, the control will ensure that the last line of input is always visible, scrolling if necessary.")
    public void setAutoScroll(boolean autoScroll) {
        this.autoScroll = autoScroll;
        this.propertyChange("autoScroll", this.autoScroll, this.autoScroll, true);
    }

    @Component.PropertyGetter(value="wrap", description="Text wrapping behavior when submitting a form.")
    public WrapMode getWrap() {
        return this.wrap;
    }

    @Component.PropertySetter(value="wrap", defaultValue="soft", description="Text wrapping behavior when submitting a form.")
    public void setWrap(WrapMode wrap) {
        this.wrap = this.defaultify(wrap, WrapMode.SOFT);
        this.propertyChange("wrap", (Object)this.wrap, (Object)this.wrap, true);
    }

    @Component.PropertyGetter(value="cols", description="The visible width of the input area in characters.")
    public int getCols() {
        return this.cols;
    }

    @Component.PropertySetter(value="cols", defaultValue="20", description="The visible width of the input area in characters.")
    public void setCols(int cols) {
        Assert.isTrue((cols > 0 ? 1 : 0) != 0, () -> "Cols must be greater than zero");
        this.cols = cols;
        this.propertyChange("cols", this.cols, this.cols, true);
    }

    @Component.PropertyGetter(value="rows", description="The visible number of rows in the input area.")
    public int getRows() {
        return this.rows;
    }

    @Component.PropertySetter(value="rows", defaultValue="2", description="The visible number of rows in the input area.")
    public void setRows(int rows) {
        Assert.isTrue((rows > 0 ? 1 : 0) != 0, () -> "Rows must be greater than zero");
        this.rows = rows;
        this.propertyChange("rows", this.rows, this.rows, true);
    }

    @Override
    protected String _toValue(String value) {
        return value;
    }

    @Override
    protected String _toString(String value) {
        return value;
    }

    public static enum WrapMode {
        HARD,
        SOFT;

    }
}

