/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.component;

import org.fujion.annotation.Component;
import org.fujion.annotation.EventHandler;
import org.fujion.component.BaseUIComponent;

@Component(tag="messagepane", widgetClass="Messagepane", content=Component.ContentHandling.AS_CHILD, parentTag={"messagewindow"}, childTag={@Component.ChildTag(value="*")}, description="A pane holding a single message in a message window.")
public class MessagePane
extends BaseUIComponent {
    private String title;
    private int duration = 8000;
    private String category;
    private boolean actionable;

    public MessagePane() {
    }

    public MessagePane(String title, String category, int duration, boolean actionable) {
        this.setTitle(title);
        this.setCategory(category);
        this.setDuration(duration);
        this.setActionable(actionable);
    }

    @Component.PropertyGetter(value="title", description="The title bar text.")
    public String getTitle() {
        return this.title;
    }

    @Component.PropertySetter(value="title", description="The title bar text.")
    public void setTitle(String title) {
        this.title = this.nullify(title);
        this.propertyChange("title", this.title, this.title, true);
    }

    @Component.PropertyGetter(value="duration", description="The duration, in milliseconds, that the message will be displayed.")
    public int getDuration() {
        return this.duration;
    }

    @Component.PropertySetter(value="duration", defaultValue="8000", description="The duration, in milliseconds, that the message will be displayed.")
    public void setDuration(int duration) {
        this.duration = duration;
        this.propertyChange("duration", this.duration, this.duration, true);
    }

    @Component.PropertyGetter(value="category", description="The category of the message.")
    public String getCategory() {
        return this.category;
    }

    @Component.PropertySetter(value="category", description="The category of the message.")
    public void setCategory(String category) {
        this.category = this.nullify(category);
    }

    @Component.PropertyGetter(value="actionable", description="True if the message is actionable.  An actionable message has an action icon that, when clicked, triggers an action event.")
    public boolean isActionable() {
        return this.actionable;
    }

    @Component.PropertySetter(value="actionable", defaultValue="false", description="True if the message is actionable.  An actionable message has an action icon that, when clicked, triggers an action event.")
    public void setActionable(boolean actionable) {
        this.actionable = actionable;
        this.propertyChange("actionable", this.actionable, this.actionable, true);
    }

    @EventHandler(value={"close"}, syncToClient=false)
    private void _close() {
        this.destroy();
    }
}

