/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.event;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.reflect.ConstructorUtils;
import org.fujion.annotation.EventParameterScanner;
import org.fujion.annotation.EventTypeScanner;
import org.fujion.client.ClientRequest;
import org.fujion.client.ExecutionContext;
import org.fujion.common.MiscUtil;
import org.fujion.component.BaseComponent;
import org.fujion.component.Page;
import org.fujion.event.Event;
import org.fujion.event.ForwardedEvent;
import org.springframework.util.Assert;

public class EventUtil {
    private static final Class<?>[] CTOR_PARAM_TYPES = new Class[]{BaseComponent.class, Object.class};

    public static void send(Event event) {
        BaseComponent target = event.getCurrentTarget();
        EventUtil.send(event, target);
    }

    public static void send(Event event, BaseComponent target) {
        if (target != null) {
            target.fireEvent(event);
        }
    }

    public static Event send(String eventName, BaseComponent target, Object data) {
        Event event = new Event(eventName, target, data);
        EventUtil.send(event);
        return event;
    }

    public static void echo(Event event) {
        event.getPage().invoke("id", response -> EventUtil.send(event), new Object[0]);
    }

    public static void post(Event event) {
        Page page = event.getPage();
        EventUtil.post(page != null ? page : ExecutionContext.getPage(), event);
    }

    public static void post(Page page, Event event) {
        page.getEventQueue().queue(event);
    }

    public static Event post(String eventName, BaseComponent target, Object data) {
        Event event = new Event(eventName, target, data);
        EventUtil.post(event);
        return event;
    }

    public static Event post(Page page, String eventName, BaseComponent target, Object data) {
        Event event = new Event(eventName, target, data);
        EventUtil.post(page, event);
        return event;
    }

    public static Class<? extends Event> getEventClass(String eventType) {
        return EventTypeScanner.getInstance().getEventClass(EventUtil.stripOn(eventType));
    }

    public static String getEventType(Class<? extends Event> eventClass) {
        return EventTypeScanner.getInstance().getEventType(eventClass);
    }

    public static String stripOn(String eventType) {
        return eventType.startsWith("on") ? StringUtils.uncapitalize((String)eventType.substring(2)) : eventType;
    }

    public static boolean invokeHandler(String handlerName, Object instance, Event event) {
        Method method = EventUtil.getHandler(handlerName, instance, event);
        if (method != null) {
            try {
                if (method.getParameterCount() == 1) {
                    method.invoke(instance, event);
                } else {
                    method.invoke(instance, new Object[0]);
                }
                return true;
            }
            catch (Exception e) {
                throw MiscUtil.toUnchecked((Throwable)e);
            }
        }
        return false;
    }

    public static Method getHandler(String handlerName, Object instance, Event event) {
        handlerName = handlerName != null ? handlerName : event.getType();
        Method method = MethodUtils.getMatchingAccessibleMethod(instance.getClass(), (String)handlerName, (Class[])new Class[]{event.getClass()});
        return method != null ? method : MethodUtils.getAccessibleMethod(instance.getClass(), (String)handlerName, (Class[])ArrayUtils.EMPTY_CLASS_ARRAY);
    }

    public static boolean hasEvent(ClientRequest request) {
        return "event".equals(request.getType()) && request.getData() instanceof Map;
    }

    public static boolean hasEvent(ClientRequest request, String eventType) {
        return eventType.equals(EventUtil.getEventType(request));
    }

    public static Event toEvent(ClientRequest request) {
        String type = EventUtil.getEventType(request);
        if (type == null) {
            throw new IllegalArgumentException("Request does not contain an event");
        }
        return EventUtil.toEvent(EventUtil.getEventClass(type), request);
    }

    public static String getEventType(ClientRequest request) {
        return EventUtil.hasEvent(request) ? (String)request.getData(Map.class).get("type") : null;
    }

    public static Event toEvent(String eventType) {
        return EventUtil.toEvent(eventType, null, null);
    }

    public static Event toEvent(String eventType, BaseComponent target, Object data) {
        String type = EventUtil.stripOn(eventType);
        Class<? extends Event> eventClass = EventUtil.getEventClass(type);
        try {
            if (eventClass == Event.class) {
                return new Event(type, target, data);
            }
            if (target == null && data == null) {
                return eventClass.newInstance();
            }
            Constructor ctor = ConstructorUtils.getMatchingAccessibleConstructor(eventClass, (Class[])CTOR_PARAM_TYPES);
            Assert.notNull((Object)ctor, () -> "Cannot find compatible constructor for event type " + type);
            return (Event)ctor.newInstance(target, data);
        }
        catch (Exception e) {
            throw MiscUtil.toUnchecked((Throwable)e);
        }
    }

    private static Event toEvent(Class<?> clazz, ClientRequest request) {
        try {
            if (Event.class.isAssignableFrom(clazz)) {
                Event event = (Event)clazz.newInstance();
                EventParameterScanner.wire(event, request);
                return event;
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            return EventUtil.toEvent(clazz.getSuperclass(), request);
        }
        return null;
    }

    public static Event getOriginalEvent(Event event) {
        while (event instanceof ForwardedEvent) {
            event = ((ForwardedEvent)event).getOriginalEvent();
        }
        return event;
    }

    private EventUtil() {
    }
}

