/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.page;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fujion.common.AbstractCache;
import org.fujion.common.StrUtil;
import org.fujion.core.WebUtil;
import org.fujion.page.PageDefinition;
import org.fujion.page.PageParser;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.web.context.ServletContextAware;

public class PageDefinitionCache
extends AbstractCache<String, PageDefinition>
implements ServletContextAware,
ApplicationListener<ContextRefreshedEvent> {
    private static PageDefinitionCache instance = new PageDefinitionCache();
    private static Log log = LogFactory.getLog(PageDefinitionCache.class);
    private Set<String> precompiled = new LinkedHashSet<String>();
    private ServletContext servletContext;

    public static PageDefinitionCache getInstance() {
        return instance;
    }

    private PageDefinitionCache() {
    }

    private String normalizeKey(String key) {
        try {
            return WebUtil.getResource(key, this.servletContext).getURL().toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    public void setPrecompiled(String fsps) {
        this.setPrecompiled(StrUtil.toList((String)fsps, (String)","));
    }

    public void setPrecompiled(Collection<String> fsps) {
        this.precompiled.addAll(fsps);
    }

    public PageDefinition get(String key) {
        String nkey = this.normalizeKey(key);
        return nkey == null ? this.fetch(key) : (PageDefinition)super.get((Object)nkey);
    }

    public boolean isCached(String key) {
        return (key = this.normalizeKey(key)) != null && super.isCached((Object)key);
    }

    protected PageDefinition fetch(String url) {
        return PageParser.getInstance().parse(url);
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (this.precompiled != null) {
            Set<String> fsps = this.precompiled;
            this.precompiled = null;
            for (String url : fsps) {
                if ((url = url.trim()).isEmpty()) continue;
                if (!"fsp".equals(FilenameUtils.getExtension((String)url))) {
                    url = url + ".fsp";
                }
                try {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Precompiling " + url));
                    }
                    this.get(url);
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)("Error precompiling " + url), (Throwable)e);
                }
            }
        }
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

