/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.schema;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.io.FileUtils;
import org.fujion.common.DateUtil;
import org.fujion.common.MiscUtil;
import org.fujion.common.StrUtil;
import org.fujion.schema.SchemaGenerator;

public class SchemaAssembler {
    private final Map<String, BiConsumer<String, String>> tokens = new HashMap<String, BiConsumer<String, String>>();
    private final List<String> schemas = new ArrayList<String>();
    private final File template;
    private final File config;
    private final File outdir;
    private final String version;
    private OutputStream out;

    public static void main(String ... args) throws Exception {
        Options options = new Options();
        Option option = new Option("c", "config", true, "Configuration file");
        option.setType(File.class);
        option.setRequired(true);
        options.addOption(option);
        option = new Option("t", "template", true, "Schema template file");
        option.setType(File.class);
        option.setRequired(true);
        options.addOption(option);
        option = new Option("o", "outdir", true, "Output directory");
        option.setType(File.class);
        option.setRequired(true);
        options.addOption(option);
        option = new Option("v", "version", true, "Schema version");
        option.setRequired(true);
        options.addOption(option);
        option = new Option("h", "help", false, "This help message");
        options.addOption(option);
        CommandLine cmd = new DefaultParser().parse(options, args);
        if (cmd.hasOption("h")) {
            new HelpFormatter().printHelp("SchemaGenerator [options] ...", options);
            return;
        }
        new SchemaAssembler(cmd).run();
    }

    private SchemaAssembler(CommandLine cmd) throws Exception {
        this.template = (File)cmd.getParsedOptionValue("template");
        this.assertExists(this.template, "Template file");
        this.config = (File)cmd.getParsedOptionValue("config");
        this.assertExists(this.config, "Configuration file");
        this.outdir = (File)cmd.getParsedOptionValue("outdir");
        this.version = cmd.getOptionValue("version");
    }

    private void run() throws Exception {
        this.initTokenConsumers();
        this.generateIndividualSchemas();
        this.generateCompositeSchema();
    }

    private void assertExists(File file, String type) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException(type + " not found at " + file);
        }
    }

    private void write(String data) {
        try {
            this.out.write(data.getBytes());
            this.out.write(10);
        }
        catch (IOException e) {
            throw MiscUtil.toUnchecked((Throwable)e);
        }
    }

    private void initTokenConsumers() {
        this.tokens.put("${schema-name}", (token, value) -> {
            for (String schema : this.schemas) {
                this.write(value.replace((CharSequence)token, schema));
            }
        });
        this.tokens.put("${schema-version}", (token, value) -> this.write(value.replace((CharSequence)token, SchemaGenerator.formatVersion(this.version))));
        this.tokens.put("${app-version}", (token, value) -> this.write(value.replace((CharSequence)token, this.version)));
        this.tokens.put("${generated-on}", (token, value) -> this.write(value.replace((CharSequence)token, DateUtil.formatDate((Date)new Date()))));
    }

    private void generateIndividualSchemas() throws Exception {
        for (String prop : FileUtils.readLines((File)this.config, (Charset)StrUtil.UTF8)) {
            if ((prop = prop.trim().replace("=", ",")).isEmpty() || prop.startsWith("#")) continue;
            String[] pcs = prop.split("\\,", 3);
            this.schemas.add(pcs[0]);
            this.generateSchema(pcs[0], pcs[1], pcs.length == 2 ? null : pcs[2]);
        }
    }

    private void generateCompositeSchema() throws Exception {
        System.out.println("Generating composite schema...");
        File outfile = new File(this.outdir, "fsp.xsd");
        try (FileOutputStream strm = new FileOutputStream(outfile);){
            this.out = strm;
            for (String tmpl : FileUtils.readLines((File)this.template, (Charset)StrUtil.UTF8)) {
                boolean found = false;
                for (String token : this.tokens.keySet()) {
                    found = tmpl.contains(token);
                    if (!found) continue;
                    this.tokens.get(token).accept(token, tmpl);
                    break;
                }
                if (found) continue;
                this.write(tmpl);
            }
        }
    }

    private void generateSchema(String name, String title, String pkgs) throws Exception {
        System.out.println("Generating schema for " + title + "...");
        SchemaGenerator.main(pkgs == null ? "-r" : "-p=" + pkgs, "-v=" + this.version, "-t=" + title, this.outdir.getAbsolutePath() + "/fsp-" + name + ".xsd");
    }
}

