/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.fujion.common.MiscUtil;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;

class DynamicResource
extends AbstractResource {
    private final File file;
    private final String description;
    private final long contentLength;

    public DynamicResource(String filename, Resource resource) {
        try {
            this.description = resource.getDescription();
            this.contentLength = resource.contentLength();
            this.file = File.createTempFile("fujion_", "." + FilenameUtils.getExtension((String)filename));
            FileUtils.copyInputStreamToFile((InputStream)resource.getInputStream(), (File)this.file);
        }
        catch (IOException e) {
            throw MiscUtil.toUnchecked((Throwable)e);
        }
    }

    public boolean isFile() {
        return true;
    }

    public File getFile() {
        return this.file;
    }

    public String getFilename() {
        return this.file.getName();
    }

    public URL getURL() throws MalformedURLException {
        return this.getURI().toURL();
    }

    public URI getURI() {
        return this.file.toURI();
    }

    public String getDescription() {
        return this.description;
    }

    public InputStream getInputStream() throws FileNotFoundException {
        return new FileInputStream(this.file);
    }

    public long contentLength() {
        return this.contentLength;
    }

    public boolean exists() {
        return true;
    }

    public void finalize() throws Throwable {
        FileUtils.deleteQuietly((File)this.file);
        super.finalize();
    }
}

