/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.servlet;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fujion.servlet.DynamicResourceResolver;
import org.fujion.servlet.ETagExceptionResolver;
import org.fujion.servlet.EmptyResourceResolver;
import org.fujion.servlet.FujionResourceTransformer;
import org.fujion.servlet.MinifiedResourceResolver;
import org.fujion.webjar.WebJarResourceResolver;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.http.CacheControl;
import org.springframework.http.MediaType;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceChainRegistration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.i18n.LocaleChangeInterceptor;
import org.springframework.web.servlet.mvc.WebContentInterceptor;
import org.springframework.web.servlet.resource.AppCacheManifestTransformer;
import org.springframework.web.servlet.resource.GzipResourceResolver;
import org.springframework.web.servlet.resource.ResourceResolver;
import org.springframework.web.servlet.resource.ResourceTransformer;

@EnableWebMvc
@Configuration
public class ServletConfiguration
implements WebMvcConfigurer,
ApplicationContextAware {
    private static final Log log = LogFactory.getLog(ServletConfiguration.class);
    private final GzipResourceResolver gzipResourceResolver = new GzipResourceResolver();
    private final ResourceResolver webjarResourceResolver = new WebJarResourceResolver();
    private final ResourceResolver dynamicResourceResolver = new DynamicResourceResolver();
    private final MinifiedResourceResolver minifiedResourceResolver = new MinifiedResourceResolver("js", "css");
    private final EmptyResourceResolver emptyResourceResolver = new EmptyResourceResolver();
    private final FujionResourceTransformer fujionResourceTransformer = new FujionResourceTransformer();
    private final AppCacheManifestTransformer appCacheManifestTransformer = new AppCacheManifestTransformer();
    private ApplicationContext applicationContext;

    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        configurer.mediaType("fsp", MediaType.TEXT_HTML);
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        this.addResourceHandlers(registry, "/dynamic/**", "/", this.dynamicResourceResolver);
        this.addResourceHandlers(registry, "/webjars/**", "classpath:/META-INF/resources/webjars/", this.webjarResourceResolver);
        this.addResourceHandlers(registry, "/web/**", "classpath:/web/", new ResourceResolver[0]);
        this.addResourceHandlers(registry, "/empty/**", "/", new ResourceResolver[]{this.emptyResourceResolver});
        this.addResourceHandlers(registry, "/**", "/", new ResourceResolver[0]);
    }

    public void addInterceptors(InterceptorRegistry registry) {
        WebContentInterceptor wci = new WebContentInterceptor();
        wci.addCacheMapping(CacheControl.noStore(), new String[]{"/**/*.fsp"});
        registry.addInterceptor((HandlerInterceptor)wci);
        registry.addInterceptor((HandlerInterceptor)new LocaleChangeInterceptor());
    }

    public void extendHandlerExceptionResolvers(List<HandlerExceptionResolver> resolvers) {
        resolvers.add(0, new ETagExceptionResolver());
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        try {
            Resource[] resources = this.applicationContext.getResources("/index.*");
            if (resources.length > 0) {
                if (resources.length > 1) {
                    log.warn((Object)"Multiple home page candidates detected - only one will be selected.");
                }
                String file = "/" + resources[0].getFilename();
                registry.addRedirectViewController("/", file);
                log.info((Object)("Default home page set to: " + file));
            } else {
                log.info((Object)"No default home page detected.");
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while attempting to detect default home page.", (Throwable)e);
        }
    }

    private void addResourceHandlers(ResourceHandlerRegistry registry, String pattern, String locations, ResourceResolver ... resolvers) {
        ResourceChainRegistration chain = registry.addResourceHandler(new String[]{pattern}).addResourceLocations(new String[]{locations}).resourceChain(false);
        for (ResourceResolver resolver : resolvers) {
            chain.addResolver(resolver);
        }
        chain.addResolver((ResourceResolver)this.minifiedResourceResolver).addResolver((ResourceResolver)this.gzipResourceResolver).addTransformer((ResourceTransformer)this.fujionResourceTransformer).addTransformer((ResourceTransformer)this.appCacheManifestTransformer);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

