/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.theme;

import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.fujion.common.StrUtil;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.ThemeResolver;

public class ThemeResolvers
implements BeanPostProcessor,
ThemeResolver {
    private static final String THEME_ATTR = ThemeResolvers.class.getName();
    private static final ThemeResolvers instance = new ThemeResolvers();
    private final Set<ThemeResolver> themeResolvers = new TreeSet<ThemeResolver>((tr1, tr2) -> this.getOrder((ThemeResolver)tr1) - this.getOrder((ThemeResolver)tr2));
    private String defaultTheme = "default";

    public static ThemeResolvers getInstance() {
        return instance;
    }

    private ThemeResolvers() {
    }

    private int getOrder(ThemeResolver themeResolver) {
        return themeResolver instanceof Ordered ? ((Ordered)themeResolver).getOrder() : Integer.MAX_VALUE;
    }

    public String resolveThemeName(HttpServletRequest request) {
        String themeName = this.getThemeName(request);
        Iterator<ThemeResolver> iter = this.themeResolvers.iterator();
        while (iter.hasNext() && !StringUtils.hasText((String)themeName)) {
            themeName = iter.next().resolveThemeName(request);
        }
        this.cacheThemeName(request, themeName);
        return StringUtils.hasText((String)themeName) ? themeName : this.defaultTheme;
    }

    private String getThemeName(HttpServletRequest request) {
        String themeName = (String)request.getAttribute(THEME_ATTR);
        String string = themeName = StringUtils.hasText((String)themeName) ? themeName : request.getParameter("theme");
        if (!StringUtils.hasText((String)themeName)) {
            int i;
            String referer = request.getHeader("Referer");
            int n = i = referer == null ? -1 : referer.indexOf("?");
            if (i > -1) {
                for (NameValuePair nvp : URLEncodedUtils.parse((String)referer.substring(i + 1), (Charset)StrUtil.UTF8)) {
                    if (!"theme".equals(nvp.getName())) continue;
                    themeName = nvp.getValue();
                    break;
                }
            }
        }
        return themeName;
    }

    private void cacheThemeName(HttpServletRequest request, String themeName) {
        request.setAttribute(THEME_ATTR, (Object)themeName);
    }

    public void setThemeName(HttpServletRequest request, HttpServletResponse response, String themeName) {
        themeName = StringUtils.hasText((String)themeName) ? themeName : this.defaultTheme;
        for (ThemeResolver themeResolver : this.themeResolvers) {
            themeResolver.setThemeName(request, response, themeName);
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof ThemeResolver) {
            this.themeResolvers.add((ThemeResolver)bean);
        }
        return bean;
    }

    public String getDefaultTheme() {
        return this.defaultTheme;
    }

    public void setDefaultTheme(String defaultTheme) {
        this.defaultTheme = defaultTheme;
    }
}

