/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.webjar;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fujion.common.JSONUtil;
import org.fujion.common.MiscUtil;
import org.fujion.common.XMLUtil;
import org.fujion.core.WebUtil;
import org.fujion.webjar.WebJar;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;

public class WebJarLocator
implements ApplicationContextAware {
    private static final Log log = LogFactory.getLog(WebJarLocator.class);
    private static final WebJarLocator instance = new WebJarLocator();
    private static final String[] OPEN_TAGS = new String[]{"<requirejs>", "<systemjs>"};
    private static final String[] CLOSE_TAGS = new String[]{"</requirejs>", "</systemjs>"};
    private ObjectNode config;
    private String webjarInit;
    private ApplicationContext applicationContext;
    private final Map<String, WebJar> webjars = new HashMap<String, WebJar>();

    public static WebJarLocator getInstance() {
        return instance;
    }

    private WebJarLocator() {
    }

    public String getWebJarInit() {
        return this.webjarInit;
    }

    public ObjectNode getConfig() {
        return this.config.deepCopy();
    }

    public WebJar getWebjar(String name) {
        return this.webjars.get(name);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        try {
            Resource[] resources = applicationContext.getResources("classpath*:/**/META-INF/resources/webjars/?*/?*/");
            ObjectMapper parser = new ObjectMapper().configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true).configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            this.config = this.createConfig(parser);
            for (Resource resource : resources) {
                try {
                    boolean success;
                    WebJar webjar;
                    String name;
                    if (resource.isFile() && !resource.getFile().isDirectory()) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Parsing configuration data for web jar: " + resource));
                    }
                    if (this.webjars.containsKey(name = (webjar = new WebJar(resource)).getName())) {
                        log.warn((Object)("Duplicate webjar was ignored: " + webjar));
                        continue;
                    }
                    this.webjars.put(name, webjar);
                    boolean bl = success = this.tryPOMFormat(webjar, parser) || this.tryBowerFormat(webjar, parser) || this.tryNPMFormat(webjar, parser);
                    if (success) {
                        JSONUtil.merge((JsonNode)this.config, (JsonNode)webjar.getConfig(), (boolean)true);
                        continue;
                    }
                    log.warn((Object)("No configuration information found for web jar: " + webjar.getName()));
                }
                catch (Exception e) {
                    log.error((Object)("Error extracting configuration information from web jar: " + resource), (Throwable)e);
                }
            }
            this.doConfigOverrides("classpath*:/META-INF/", parser);
            this.doConfigOverrides("WEB-INF/", parser);
            this.webjarInit = WebUtil.isDebugEnabled() ? parser.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this.config) : this.config.toString();
        }
        catch (IOException e) {
            throw MiscUtil.toUnchecked((Throwable)e);
        }
    }

    private ObjectNode createConfig(ObjectMapper parser) {
        ObjectNode config = parser.createObjectNode();
        config.set("map", (JsonNode)parser.createObjectNode());
        config.set("paths", (JsonNode)parser.createObjectNode());
        config.set("packages", (JsonNode)parser.createObjectNode());
        return config;
    }

    private void doConfigOverrides(String path, ObjectMapper parser) {
        try {
            Resource[] resources;
            for (Resource resource : resources = this.applicationContext.getResources(path + "systemjs.config.json")) {
                try (InputStream is = resource.getInputStream();){
                    JSONUtil.merge((JsonNode)this.config, (JsonNode)parser.readTree(is), (boolean)true);
                }
            }
        }
        catch (FileNotFoundException resources) {
        }
        catch (IOException e) {
            throw MiscUtil.toUnchecked((Throwable)e);
        }
    }

    private boolean tryPOMFormat(WebJar webjar, ObjectMapper parser) {
        try {
            String pomPath = webjar.getAbsolutePath();
            int i = pomPath.lastIndexOf("/META-INF/") + 10;
            pomPath = pomPath.substring(0, i) + "maven/**/pom.xml";
            Resource[] poms = this.applicationContext.getResources(pomPath);
            return poms.length > 0 && this.extractConfig(poms[0], webjar, parser);
        }
        catch (Exception e) {
            log.error((Object)("Error processing configuration data from " + webjar), (Throwable)e);
            return false;
        }
    }

    private boolean extractConfig(Resource pomResource, WebJar webjar, ObjectMapper parser) throws Exception {
        try (InputStream is = pomResource.getInputStream();){
            boolean bl;
            String json;
            LineIterator iter = IOUtils.lineIterator((InputStream)is, (Charset)StandardCharsets.UTF_8);
            StringBuilder sb = null;
            int tag = -1;
            while (iter.hasNext()) {
                int pos;
                String line = (String)iter.next();
                if (sb == null) {
                    for (tag = 0; tag < 2; ++tag) {
                        pos = line.indexOf(OPEN_TAGS[tag]);
                        if (pos < 0) continue;
                        sb = new StringBuilder();
                        line = line.substring(pos);
                        break;
                    }
                    if (sb == null) continue;
                }
                if ((pos = line.indexOf(CLOSE_TAGS[tag])) >= 0) {
                    sb.append(line.substring(0, pos + CLOSE_TAGS[tag].length()));
                    break;
                }
                sb.append(line);
            }
            String string = json = sb == null ? null : StringUtils.trimToNull((String)XMLUtil.parseXMLFromString((String)sb.toString()).getDocumentElement().getTextContent());
            if (json == null) {
                bl = false;
                return bl;
            }
            if (!json.startsWith("{")) {
                json = "{" + json + "}";
            }
            webjar.setConfig((ObjectNode)parser.readTree(json));
            bl = true;
            return bl;
        }
    }

    private boolean tryBowerFormat(WebJar webjar, ObjectMapper parser) {
        return this.extractConfig("bower.json", webjar, parser);
    }

    private boolean tryNPMFormat(WebJar webjar, ObjectMapper parser) {
        return this.extractConfig("package.json", webjar, parser);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean extractConfig(String packageFile, WebJar webjar, ObjectMapper parser) {
        try {
            Resource configResource = webjar.createRelative(packageFile);
            if (!configResource.exists()) return false;
            try (InputStream is = configResource.getInputStream();){
                JsonNode cfg = parser.readTree(is);
                String name = cfg.get("name").asText();
                String main = this.getMain(cfg.get("main"));
                if (main != null) {
                    main = StringUtils.removeStart((String)main, (String)"./");
                    ObjectNode config = this.createConfig(parser);
                    webjar.setConfig(config);
                    ObjectNode paths = (ObjectNode)config.get("paths");
                    paths.set(name, (JsonNode)new TextNode(main));
                }
                boolean bl = main != null;
                return bl;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private String getMain(JsonNode node) {
        if (node != null) {
            if (node.isArray()) {
                Iterator iter = node.elements();
                if (iter.hasNext()) {
                    return this.getMain((JsonNode)iter.next());
                }
            } else {
                return node.asText();
            }
        }
        return null;
    }
}

