/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.core.test;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.fujion.ancillary.ConvertUtil;
import org.fujion.ancillary.CssClasses;
import org.fujion.ancillary.CssStyles;
import org.fujion.ancillary.DeferredInvocation;
import org.fujion.ancillary.JavaScript;
import org.fujion.ancillary.MimeContent;
import org.fujion.annotation.ComponentDefinition;
import org.fujion.annotation.ComponentScanner;
import org.fujion.common.MiscUtil;
import org.fujion.component.BaseComponent;
import org.fujion.component.Button;
import org.fujion.component.Combobox;
import org.fujion.component.Comboitem;
import org.fujion.component.Div;
import org.fujion.component.Label;
import org.fujion.component.Page;
import org.fujion.component.Radiobutton;
import org.fujion.component.Radiogroup;
import org.fujion.component.Textbox;
import org.fujion.component.Toolbar;
import org.fujion.component.Treenode;
import org.fujion.component.Treeview;
import org.fujion.core.test.TestBinder;
import org.fujion.event.KeyCode;
import org.fujion.page.PageDefinition;
import org.fujion.page.PageElement;
import org.fujion.page.PageParser;
import org.fujion.page.PageSource;
import org.fujion.page.PageUtil;
import org.fujion.theme.Theme;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.util.Base64Utils;

public class Tests {
    private static final String ATTR_TEST = "ATTR_TEST";
    private static final String ATTR_OBJECT = "ATTR_OBJECT";
    private static final String ATTR_NULL = "ATTR_NULL";
    private static final byte[] TEST_CONTENT = new byte[]{97, 101, 105, 111, 117};
    private static final String GREEN = "green";
    private static final String RED = "red";
    private static final String ORANGE = "orange";
    private final String[] nodes = new String[]{"1.1", "2.1", "3.1", "2.2", "1.2", "1.3", "2.1", "3.1", "2.2"};

    @BeforeClass
    public static void beforeTests() {
        ComponentScanner.getInstance().scanPackage("org.fujion.component");
    }

    @Test
    public void parserTests() {
        PageDefinition pagedef = this.getPageDefinition("test.fsp");
        PageElement pgele = (PageElement)pagedef.getRootElement().getChildren().iterator().next();
        ComponentDefinition cmpdef = pgele.getDefinition();
        Assert.assertEquals((Object)"page", (Object)cmpdef.getTag());
        Assert.assertEquals(Page.class, (Object)cmpdef.getComponentClass());
        Assert.assertEquals((Object)"page", pgele.getAttributes().get("name"));
        Page page = new Page();
        List roots = PageUtil.createPage((PageDefinition)pagedef, (BaseComponent)page, null);
        Assert.assertEquals((long)1L, (long)roots.size());
        Assert.assertEquals((Object)page, roots.get(0));
        Assert.assertEquals((Object)"page", (Object)page.getName());
        Assert.assertEquals((Object)"The Page Title", (Object)page.getTitle());
    }

    @Test
    public void attributeTests() {
        Div cmpt = new Div();
        cmpt.setAttribute((Object)ATTR_OBJECT, new Object());
        cmpt.setAttribute((Object)ATTR_TEST, (Object)1234);
        Assert.assertTrue((1234 == (Integer)cmpt.getAttribute(ATTR_TEST, (Object)0) ? 1 : 0) != 0);
        Assert.assertTrue((4321 == (Integer)cmpt.getAttribute(ATTR_OBJECT, (Object)4321) ? 1 : 0) != 0);
        Assert.assertTrue((5678 == (Integer)cmpt.getAttribute(ATTR_NULL, (Object)5678) ? 1 : 0) != 0);
        cmpt.setAttribute((Object)ATTR_TEST, (Object)true);
        Assert.assertTrue((boolean)((Boolean)cmpt.getAttribute(ATTR_TEST, Boolean.class)));
        cmpt.setAttribute((Object)ATTR_TEST, (Object)"TRUE");
        Assert.assertTrue((boolean)((Boolean)cmpt.getAttribute(ATTR_TEST, Boolean.class)));
        cmpt.setAttribute((Object)ATTR_TEST, (Object)"ANYTHING BUT TRUE");
        Assert.assertNull((Object)cmpt.getAttribute(ATTR_TEST, Boolean.class));
        Assert.assertNull((Object)cmpt.getAttribute(ATTR_OBJECT, Boolean.class));
        Assert.assertNull((Object)cmpt.getAttribute(ATTR_NULL, Boolean.class));
        cmpt.setAttribute((Object)ATTR_TEST, (Object)ATTR_TEST);
        Assert.assertEquals((Object)ATTR_TEST, (Object)cmpt.getAttribute(ATTR_TEST, String.class));
        Assert.assertTrue((boolean)((String)cmpt.getAttribute(ATTR_OBJECT, String.class)).contains("Object"));
        Assert.assertNull((Object)cmpt.getAttribute(ATTR_NULL, String.class));
        ArrayList list = new ArrayList();
        cmpt.setAttribute((Object)ATTR_TEST, list);
        Assert.assertSame(list, (Object)cmpt.getAttribute(ATTR_TEST, List.class));
        Assert.assertNotNull((Object)cmpt.getAttribute((Object)ATTR_OBJECT));
        Assert.assertNull((Object)cmpt.getAttribute((Object)ATTR_NULL));
        cmpt.setAttribute((Object)ATTR_TEST, (Object)cmpt);
        Assert.assertSame((Object)cmpt, (Object)cmpt.getAttribute(ATTR_TEST, Div.class));
        Assert.assertNull((Object)cmpt.getAttribute(ATTR_OBJECT, Div.class));
    }

    @Test
    public void namespaceTests() {
        PageDefinition pagedef = this.getPageDefinition("nstest.fsp");
        BaseComponent root = (BaseComponent)pagedef.materialize(null).get(0);
        BaseComponent ref = root.findByName("myinner");
        Assert.assertNotNull((Object)ref);
        BaseComponent cmp = ref.findByName("mycomp");
        Assert.assertTrue((boolean)(cmp instanceof Button));
        cmp = ref.findByName("^/mycomp");
        Assert.assertTrue((boolean)(cmp instanceof Label));
        cmp = ref.findByName("mycomp2");
        Assert.assertTrue((boolean)(cmp instanceof Toolbar));
        cmp = ref.findByName("^/mycomp2");
        Assert.assertNull((Object)cmp);
        cmp = ref.findByName("^/myinner/mycomp2");
        Assert.assertTrue((boolean)(cmp instanceof Toolbar));
        cmp = ref.findByName("^/mycomp/myinner/mycomp");
        Assert.assertTrue((boolean)(cmp instanceof Button));
    }

    @Test
    public void conversionTests() {
        Assert.assertEquals((Object)"true", (Object)ConvertUtil.convert((Object)true, String.class));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ConvertUtil.convert((Object)"true", Boolean.class));
        Assert.assertEquals((Object)((Object)TestEnum.TEST1), (Object)ConvertUtil.convert((Object)"test1", TestEnum.class));
        Assert.assertEquals((Object)"TEST2", (Object)ConvertUtil.convert((Object)((Object)TestEnum.TEST2), String.class));
        Assert.assertEquals((Object)"function() {var x=1}", (Object)((JavaScript)ConvertUtil.convert((Object)"var x=1", JavaScript.class)).toString());
        Assert.assertEquals((Object)"function() {var x=1}", (Object)((JavaScript)ConvertUtil.convert((Object)"function() {var x=1}", JavaScript.class)).toString());
    }

    @Test
    public void cssClassesTests() {
        CssClasses classes = new CssClasses();
        Assert.assertTrue((!classes.hasChanged() ? 1 : 0) != 0);
        classes.parse("flavor:red size:big test");
        Assert.assertTrue((boolean)classes.hasChanged());
        Assert.assertEquals((Object)"big red test", (Object)classes.toString());
        classes.add(new String[]{"flavor:blue size:small -test"});
        Assert.assertEquals((Object)"blue small", (Object)classes.toString());
        classes.remove(new String[]{"flavor:"});
        Assert.assertEquals((Object)"small", (Object)classes.toString());
        classes.add(new String[]{"-size:"});
        Assert.assertTrue((boolean)classes.hasChanged());
        Assert.assertEquals((Object)"", (Object)classes.toString(true));
        Assert.assertTrue((!classes.hasChanged() ? 1 : 0) != 0);
    }

    @Test
    public void cssStylesTests() {
        CssStyles styles = new CssStyles();
        Assert.assertTrue((boolean)styles.isEmpty());
        styles.put("style1", "value1");
        Assert.assertTrue((!styles.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((Object)"style1:value1", (Object)styles.toString());
        Assert.assertEquals((Object)"value1", (Object)styles.get("style1"));
        styles.parse("style2 : value2", false);
        Assert.assertEquals((Object)"style1:value1;style2:value2", (Object)styles.toString());
        Assert.assertEquals((Object)"value1", (Object)styles.get("style1"));
        Assert.assertEquals((Object)"value2", (Object)styles.get("style2"));
        styles.remove("style1");
        Assert.assertEquals((Object)"style2:value2", (Object)styles.toString());
        Assert.assertNull((Object)styles.get("style1"));
        styles.parse("style1:value1", true);
        Assert.assertEquals((Object)"style1:value1", (Object)styles.toString());
        styles.put("style1", null);
        Assert.assertTrue((boolean)styles.isEmpty());
    }

    @Test
    public void deferredInvocationTests() throws Exception {
        Method method = Tests.class.getDeclaredMethod("_testMethod", String.class, String.class);
        DeferredInvocation inv1 = new DeferredInvocation((Object)this, method, new Object[0]);
        Assert.assertEquals((Object)"test1;test2", (Object)inv1.invoke(new Object[]{"test1", "test2"}));
        DeferredInvocation inv2 = new DeferredInvocation((Object)this, method, new Object[]{"test3"});
        Assert.assertEquals((Object)"test3;test4", (Object)inv2.invoke(new Object[]{"test4"}));
        DeferredInvocation inv3 = new DeferredInvocation((Object)this, method, new Object[]{"test5", "test6"});
        Assert.assertEquals((Object)"test5;test6", (Object)inv3.invoke(new Object[0]));
        DeferredInvocation inv4 = new DeferredInvocation((Object)this, method, new Object[]{TestEnum.TEST1, TestEnum.TEST2});
        Assert.assertEquals((Object)"TEST1;TEST2", (Object)inv4.invoke(new Object[0]));
        try {
            inv4.addArgs(new Object[]{new Object()});
            Assert.fail((String)"Expected illegal argument exception.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected String _testMethod(String arg1, String arg2) {
        return arg1 + ";" + arg2;
    }

    @Test
    public void keyCodeTests() {
        Assert.assertEquals((Object)KeyCode.VK_BACK_SPACE, (Object)KeyCode.fromCode((int)8));
        Assert.assertEquals((Object)KeyCode.VK_ASTERISK, (Object)KeyCode.fromString((String)"ASTERISK"));
        Assert.assertEquals((Object)KeyCode.normalizeKeyCapture((String)"^A ~F1 ^@~@^$1"), (Object)"^#65 ~#112 ^@~$#49");
    }

    @Test
    public void mimeContentTests() {
        MimeContent content = new MimeContent("image/png", TEST_CONTENT);
        String src = content.getSrc();
        Assert.assertEquals((Object)"data:image/png;base64,YWVpb3U=", (Object)src);
        Assert.assertEquals((Object)"aeiou", (Object)new String(Base64Utils.decodeFromString((String)src.split("\\,", 2)[1])));
    }

    @Test
    public void bindingTests() {
        PageDefinition pagedef = this.getPageDefinition("binding.fsp");
        TestBinder binder = new TestBinder();
        TestBinder.TestModel model = (TestBinder.TestModel)((Object)binder.getModel());
        Map<String, TestBinder> args = Collections.singletonMap("binder", binder);
        BaseComponent root = (BaseComponent)pagedef.materialize(null, args).get(0);
        this.testBinding(root, model, GREEN);
        model.setColor(RED);
        this.testBinding(root, model, RED);
        ((Textbox)root.findByName("textbox", Textbox.class)).setValue((Object)GREEN);
        this.testBinding(root, model, GREEN);
        ((Combobox)root.findByName("combobox", Combobox.class)).setSelectedIndex(1);
        this.testBinding(root, model, RED);
        ((Radiobutton)root.findByName("rbGreen", Radiobutton.class)).setChecked(true);
        this.testBinding(root, model, GREEN);
        ((Radiobutton)root.findByName("rbRed", Radiobutton.class)).setChecked(true);
        this.testBinding(root, model, RED);
        ((Comboitem)root.findByName("cbiGreen", Comboitem.class)).setSelected(true);
        this.testBinding(root, model, GREEN);
        ((Comboitem)root.findByName("cbiRed", Comboitem.class)).setSelected(true);
        this.testBinding(root, model, RED);
        ((Label)root.findByName("label", Label.class)).setLabel(GREEN);
        this.testBinding(root, model, RED, GREEN, false);
        model.setColor(ORANGE);
        this.testBinding(root, model, ORANGE, ORANGE, true);
        model.setColor(RED);
        this.testBinding(root, model, RED);
        ((Textbox)root.findByName("textbox", Textbox.class)).setValue(null);
        this.testBinding(root, model, null, null, true);
        model.setColor(GREEN);
        this.testBinding(root, model, GREEN);
    }

    private void testBinding(BaseComponent root, TestBinder.TestModel model, String value) {
        this.testBinding(root, model, value, value, false);
    }

    private void testBinding(BaseComponent root, TestBinder.TestModel model, String value, String labelValue, boolean noneSelected) {
        Textbox textbox = (Textbox)root.findByName("textbox", Textbox.class);
        Label label = (Label)root.findByName("label", Label.class);
        Combobox combobox = (Combobox)root.findByName("combobox", Combobox.class);
        Comboitem cbi = combobox.getSelectedItem();
        Radiogroup radiogroup = (Radiogroup)root.findByName("radiogroup", Radiogroup.class);
        Radiobutton rbtn = radiogroup.getSelected();
        Assert.assertEquals((Object)value, (Object)model.getColor());
        Assert.assertEquals((Object)value, (Object)textbox.getValue());
        Assert.assertEquals((Object)labelValue, (Object)label.getLabel());
        if (noneSelected) {
            Assert.assertNull((Object)cbi);
            Assert.assertNull((Object)rbtn);
            Assert.assertNull((Object)combobox.getValue());
        } else {
            Assert.assertEquals((Object)value, (Object)combobox.getValue());
            Assert.assertEquals((Object)value, (Object)cbi.getLabel());
            Assert.assertEquals((Object)value, (Object)rbtn.getLabel());
        }
    }

    @Test
    public void testTreeview() {
        Treeview tv = (Treeview)this.createPage("treeview.fsp", null).get(0);
        int index = 0;
        for (Treenode node : tv) {
            Assert.assertEquals((Object)this.nodes[index++], (Object)node.getLabel());
        }
        Assert.assertEquals((long)this.nodes.length, (long)index);
    }

    @Test
    public void testThemes() {
        Theme theme = new Theme("test-theme");
        theme.addMapping("org/acme/*/test/*/**", "org/fujion/$0/test/$2/$1/$3");
        theme.addMapping("*/test/**/*.css", "$1:$2:$3");
        theme.addMapping("/webjars/bootstrap/**", "/webjars/bootswatch-$0/$1");
        Assert.assertEquals((Object)"org/fujion/test-theme/test/test2/test1/file.xyz", (Object)theme.translatePath("org/acme/test1/test/test2/file.xyz"));
        Assert.assertEquals((Object)"test1:test2.1/test2.2:test3", (Object)theme.translatePath("test1/test/test2.1/test2.2/test3.css"));
        Assert.assertEquals((Object)"/webjars/bootswatch-test-theme/css/bootstrap.css", (Object)theme.translatePath("/webjars/bootstrap/css/bootstrap.css"));
        Assert.assertNull((Object)theme.translatePath("this/should/not/match"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PageDefinition getPageDefinition(String file) {
        try (InputStream is = this.getClass().getResourceAsStream("/" + file);){
            Assert.assertNotNull((Object)is);
            PageSource src = new PageSource(is, file);
            PageDefinition pageDefinition = PageParser.getInstance().parse(src);
            return pageDefinition;
        }
        catch (Exception e) {
            throw MiscUtil.toUnchecked((Throwable)e);
        }
    }

    private List<BaseComponent> createPage(String file, BaseComponent parent) {
        PageDefinition pagedef = this.getPageDefinition(file);
        return PageUtil.createPage((PageDefinition)pagedef, (BaseComponent)parent);
    }

    private static enum TestEnum {
        TEST1,
        TEST2,
        TEST3;

    }
}

