/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.ancillary;

import java.lang.reflect.InvocationTargetException;
import java.util.function.Supplier;
import org.apache.commons.lang.UnhandledException;
import org.fujion.component.BaseComponent;

public class ComponentException
extends UnhandledException {
    private static final long serialVersionUID = 1L;
    private final BaseComponent component;
    private final Class<? extends BaseComponent> componentClass;
    private final String message;

    public static void assertTrue(boolean condition, Supplier<String> message) {
        ComponentException.assertTrue(condition, null, null, message);
    }

    public static void assertTrue(boolean condition, Class<? extends BaseComponent> componentClass, Supplier<String> message) {
        ComponentException.assertTrue(condition, componentClass, null, message);
    }

    public static void assertTrue(boolean condition, BaseComponent component, Supplier<String> message) {
        ComponentException.assertTrue(condition, null, component, message);
    }

    private static void assertTrue(boolean condition, Class<? extends BaseComponent> componentClass, BaseComponent component, Supplier<String> message) {
        if (!condition) {
            throw new ComponentException((Throwable)null, componentClass, component, message.get(), new Object[0]);
        }
    }

    public static void assertTrue(boolean condition, String message, Object ... args) {
        ComponentException.assertTrue(condition, null, null, message, args);
    }

    public static void assertTrue(boolean condition, Class<? extends BaseComponent> componentClass, String message, Object ... args) {
        ComponentException.assertTrue(condition, componentClass, null, message, args);
    }

    public static void assertTrue(boolean condition, BaseComponent component, String message, Object ... args) {
        ComponentException.assertTrue(condition, null, component, message, args);
    }

    private static void assertTrue(boolean condition, Class<? extends BaseComponent> componentClass, BaseComponent component, String message, Object ... args) {
        if (!condition) {
            throw new ComponentException((Throwable)null, componentClass, component, message, args);
        }
    }

    private static String formatMessage(Class<? extends BaseComponent> componentClass, BaseComponent component, String message, Object ... args) {
        Object object = component != null ? component : componentClass;
        message = args == null || args.length == 0 ? message : String.format(message, args);
        return (object == null ? "" : object + ": ") + message;
    }

    private static Throwable getCause(Throwable cause) {
        return cause instanceof InvocationTargetException ? cause.getCause() : cause;
    }

    private ComponentException(Throwable cause, Class<? extends BaseComponent> componentClass, BaseComponent component, String message, Object ... args) {
        super(ComponentException.getCause(cause));
        this.message = ComponentException.formatMessage(componentClass, component, message, args);
        this.component = component;
        this.componentClass = component != null ? component.getClass() : componentClass;
    }

    public ComponentException(Throwable cause, String message, Object ... args) {
        this(cause, null, null, message, args);
    }

    public ComponentException(Throwable cause, Class<? extends BaseComponent> componentClass, String message, Object ... args) {
        this(cause, componentClass, null, message, args);
    }

    public ComponentException(Throwable cause, BaseComponent component, String message, Object ... args) {
        this(cause, null, component, message, args);
    }

    public ComponentException(String message, Object ... args) {
        this(null, null, null, message, args);
    }

    public ComponentException(Class<? extends BaseComponent> componentClass, String message, Object ... args) {
        this(null, componentClass, null, message, args);
    }

    public ComponentException(BaseComponent component, String message, Object ... args) {
        this(null, null, component, message, args);
    }

    public BaseComponent getComponent() {
        return this.component;
    }

    public Class<? extends BaseComponent> getComponentClass() {
        return this.componentClass;
    }

    public String getMessage() {
        String message = super.getMessage();
        if (message == null) {
            message = this.message;
        } else if (this.message != null) {
            message = this.message + "\n" + message;
        }
        return message;
    }
}

