/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.ancillary;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.fujion.ancillary.ComponentException;
import org.fujion.ancillary.ConvertUtil;
import org.fujion.annotation.Component;
import org.fujion.annotation.ComponentDefinition;
import org.fujion.common.MiscUtil;
import org.fujion.component.BaseComponent;
import org.fujion.expression.ELContext;
import org.fujion.expression.ELEvaluator;

public class ComponentFactory {
    private static final String SWITCH_ATTR = "@switch";
    private static final String CASE_DEFAULT = "@default";
    private final ComponentDefinition def;
    private Class<? extends BaseComponent> clazz;
    private boolean active = true;
    private Iterable<?> forEach;
    private String forVar = "each";
    private Object caseVal;
    private Object switchVal;

    public ComponentFactory(ComponentDefinition def) {
        this.def = def;
        this.clazz = def.getComponentClass();
    }

    @Component.FactoryParameter(value="impl", description="Component implementation class to substitute.")
    protected void setImplementationClass(Class<? extends BaseComponent> clazz) {
        Class<? extends BaseComponent> originalClazz = this.def.getComponentClass();
        ComponentException.assertTrue(clazz == null || originalClazz.isAssignableFrom(clazz), "Implementation class must extend class %s", originalClazz.getName());
        this.clazz = clazz;
    }

    @Component.FactoryParameter(value="if", description="If false, prevent component creation.")
    protected void setIf(boolean condition) {
        this.active &= condition;
    }

    @Component.FactoryParameter(value="unless", description="If true, prevent component creation.")
    protected void setUnless(boolean condition) {
        this.active &= !condition;
    }

    @Component.FactoryParameter(value="foreach", description="Specifies a collection for iterative component creation.")
    protected void setForEach(Object forEach) {
        this.forEach = ConvertUtil.convertToIterable(forEach);
    }

    @Component.FactoryParameter(value="forvar", defaultValue="each", description="Specifies the attribute name used in foreach.")
    protected void setForVar(String forVar) {
        forVar = (forVar = StringUtils.trimToNull((String)forVar)) == null ? "each" : forVar;
        ComponentException.assertTrue(BaseComponent.validateName(forVar), "Name \"%s\" specified in 'forvar' is not valid", forVar);
        this.forVar = forVar;
    }

    @Component.FactoryParameter(value="switch", description="Specifies the value for a switch statement.")
    protected void setSwitch(Object switchVal) {
        this.switchVal = switchVal;
    }

    @Component.FactoryParameter(value="case", description="Specifies the value for matching a switch statement.")
    protected void setCase(Object caseVal) {
        this.caseVal = caseVal;
    }

    public List<BaseComponent> create(Map<String, String> attributes, ELContext elContext) {
        BaseComponent parent;
        Object switchVal;
        if (!attributes.isEmpty()) {
            for (Map.Entry<String, Method> entry : this.def.getFactoryParameters().entrySet()) {
                String name = entry.getKey();
                if (!attributes.containsKey(name)) continue;
                Object value = ELEvaluator.getInstance().evaluate(attributes.remove(name), elContext);
                ConvertUtil.invokeMethod(this, entry.getValue(), value);
            }
        }
        if (this.active && this.caseVal != null && (this.active = this.caseMatches(switchVal = (parent = (BaseComponent)elContext.getValue("parent")) == null ? null : parent.getAttribute(SWITCH_ATTR)))) {
            parent.removeAttribute(SWITCH_ATTR);
        }
        if (!this.active) {
            return Collections.emptyList();
        }
        if (this.forEach == null) {
            return Collections.singletonList(this.create());
        }
        ArrayList<BaseComponent> components = new ArrayList<BaseComponent>();
        for (Object each : this.forEach) {
            BaseComponent comp = this.create();
            comp.setAttribute(this.forVar, each);
            components.add(comp);
        }
        return components;
    }

    private boolean caseMatches(Object switchVal) {
        if (switchVal != null) {
            for (Object val : ConvertUtil.convertToIterable(this.caseVal)) {
                if (!CASE_DEFAULT.equals(val) && !ObjectUtils.equals((Object)switchVal, val)) continue;
                return true;
            }
        }
        return false;
    }

    private BaseComponent create() {
        try {
            BaseComponent comp = this.clazz.newInstance();
            if (this.switchVal != null) {
                comp.setAttribute(SWITCH_ATTR, this.switchVal);
            }
            return comp;
        }
        catch (Exception e) {
            throw MiscUtil.toUnchecked((Throwable)e);
        }
    }
}

