/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.ancillary;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.DateConverter;
import org.fujion.ancillary.ComponentException;
import org.fujion.ancillary.JavaScript;
import org.fujion.ancillary.JavaScriptConverter;
import org.fujion.common.DateUtil;
import org.fujion.common.StrUtil;
import org.fujion.component.BaseComponent;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.w3c.dom.Element;

public class ConvertUtil {
    public static <T> T convert(Object value, Class<T> targetType) {
        return ConvertUtil.convert(value, targetType, null);
    }

    public static <T> T convert(Object value, Class<T> targetType, Object instance) {
        if (value == null || targetType == null || targetType.isInstance(value)) {
            return (T)value;
        }
        if (targetType.isEnum()) {
            return (T)ConvertUtil.convertToEnum(value, targetType);
        }
        if (BaseComponent.class.isAssignableFrom(targetType)) {
            return (T)ConvertUtil.convertToComponent(value, targetType, instance);
        }
        if (targetType == Boolean.class || targetType == Boolean.TYPE) {
            String val = value.toString().trim().toLowerCase();
            Boolean result = "true".equals(val) ? Boolean.TRUE : ("false".equals(val) ? Boolean.FALSE : null);
            Assert.notNull((Object)result, () -> "Not a valid Boolean value: " + value);
            return (T)result;
        }
        return (T)ConvertUtils.convert((Object)value, targetType);
    }

    private static Object convertToEnum(Object value, Class<?> enumType) {
        String val = ConvertUtil.convert(value, String.class, null);
        for (Object e : enumType.getEnumConstants()) {
            if (!((Enum)e).name().equalsIgnoreCase(val)) continue;
            return e;
        }
        throw new IllegalArgumentException(StrUtil.formatMessage((String)"The value \"%s\" is not a member of the enumeration %s", (Object[])new Object[]{value, enumType.getName()}));
    }

    private static BaseComponent convertToComponent(Object value, Class<?> componentType, Object instance) {
        BaseComponent target;
        String name;
        if (!BaseComponent.class.isInstance(instance)) {
            StrUtil.formatMessage((String)"The property owner is not of the expected type (was %s but expected %s)", (Object[])new Object[]{instance.getClass().getName(), BaseComponent.class.getName()});
        }
        if ((name = ConvertUtil.convert(value, String.class, instance)).trim().isEmpty()) {
            return null;
        }
        BaseComponent container = (BaseComponent)instance;
        BaseComponent baseComponent = target = name.startsWith("_fujion_") ? container.getPage().findById(name) : container.findByName(name);
        if (target == null) {
            throw new IllegalArgumentException(StrUtil.formatMessage((String)"A component with name or id \"%s\" was not found", (Object[])new Object[]{name}));
        }
        if (!componentType.isInstance(target)) {
            throw new IllegalArgumentException(StrUtil.formatMessage((String)"The component with name or id \"%s\" is not of the expected type (was %s but expected %s)", (Object[])new Object[]{name, target.getClass().getName(), componentType.getName()}));
        }
        return target;
    }

    public static Iterable<?> convertToIterable(Object value) {
        return value == null ? null : (value instanceof Iterable ? (List<Object>)value : (ObjectUtils.isArray((Object)value) ? Arrays.asList(ObjectUtils.toObjectArray((Object)value)) : (value instanceof Map ? ((Map)value).entrySet() : Collections.singletonList(value))));
    }

    public static Set<String> convertToSet(String[] values, boolean ignoreEmpty) {
        HashSet<String> set = new HashSet<String>();
        for (String value : values) {
            if (value == null || ignoreEmpty && value.isEmpty()) continue;
            set.add(value);
        }
        return set;
    }

    public static Object invokeMethod(Object instance, Method method, Object ... args) {
        try {
            Class<?>[] parameterTypes = method.getParameterTypes();
            Object[] objectArray = args = args == null ? new Object[]{} : args;
            if (args.length != parameterTypes.length) {
                throw new IllegalArgumentException(StrUtil.formatMessage((String)"Attempted to invoke method \"%s\" with the incorrect number of arguments (provided %d but expected %d)", (Object[])new Object[]{method.getName(), args.length, parameterTypes.length}));
            }
            for (int i = 0; i < parameterTypes.length; ++i) {
                args[i] = ConvertUtil.convert(args[i], parameterTypes[i], instance);
            }
            return method.invoke(instance, args);
        }
        catch (Exception e) {
            throw new ComponentException((Throwable)e, "Exception invoking method \"%s\" on component \"%s\"", method.getName(), instance.getClass().getName());
        }
    }

    public static <T> T getAttributeAs(Element element, String attributeName, Class<T> targetType) {
        return ConvertUtil.convert(element.getAttribute(attributeName), targetType);
    }

    public static <T> T getAttributeAs(Map<?, ?> map, String attributeName, Class<T> targetType) {
        return ConvertUtil.convert(map.get(attributeName), targetType);
    }

    private ConvertUtil() {
    }

    static {
        DateConverter dtc = new DateConverter();
        String[] patterns = new String[DateUtil.Format.values().length];
        int i = 0;
        for (DateUtil.Format format : DateUtil.Format.values()) {
            patterns[i++] = format.getPattern();
        }
        dtc.setUseLocaleFormat(true);
        dtc.setPatterns(patterns);
        ConvertUtils.register((Converter)dtc, Date.class);
        ConvertUtils.register((Converter)new JavaScriptConverter(), JavaScript.class);
    }
}

