/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.ancillary;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.util.StringUtils;

public class CssClasses {
    private final Set<String> classes = new TreeSet<String>();
    private final Map<String, String> groups = new HashMap<String, String>();
    private boolean changed;

    public CssClasses parse(String value) {
        this.classes.clear();
        this.groups.clear();
        this.update(false, value);
        return this;
    }

    public boolean add(String ... values) {
        return this.update(false, values);
    }

    public boolean remove(String ... values) {
        return this.update(true, values);
    }

    public boolean toggle(String yesValue, String noValue, boolean condition) {
        return this.update(condition, noValue) | this.update(!condition, yesValue);
    }

    private boolean update(boolean remove, String ... values) {
        for (String value : values) {
            if (StringUtils.isEmpty((Object)value)) continue;
            for (String cls : value.split("\\ ")) {
                cls = cls.trim();
                boolean _remove = remove;
                if (cls.startsWith("-")) {
                    cls = cls.substring(1);
                    _remove = true;
                }
                if (cls.contains(":")) {
                    String[] pcs = cls.split("\\:", 2);
                    cls = pcs[1];
                    String group = pcs[0];
                    String clazz = this.groups.get(group);
                    this.changed |= clazz != null && this.classes.remove(clazz);
                    this.groups.put(group, _remove ? "" : cls);
                }
                if (cls.isEmpty()) continue;
                if (_remove) {
                    this.changed |= this.classes.remove(cls);
                    continue;
                }
                this.changed |= this.classes.add(cls);
            }
        }
        return this.changed;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public boolean isEmpty() {
        return this.classes.isEmpty();
    }

    public String toString(boolean clearChanged) {
        StringBuilder sb = new StringBuilder();
        for (String cls : this.classes) {
            sb.append(sb.length() == 0 ? "" : " ").append(cls);
        }
        this.changed &= !clearChanged;
        return sb.toString();
    }

    public String toString() {
        return this.toString(false);
    }
}

