/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.annotation;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.IntSupplier;
import org.apache.commons.beanutils.ConstructorUtils;
import org.fujion.ancillary.ComponentException;
import org.fujion.ancillary.ComponentFactory;
import org.fujion.ancillary.ConvertUtil;
import org.fujion.ancillary.DeferredInvocation;
import org.fujion.annotation.Component;
import org.fujion.common.MiscUtil;
import org.fujion.component.BaseComponent;
import org.fujion.model.IBinding;

public class ComponentDefinition {
    private final Component.ContentHandling contentHandling;
    private final String tag;
    private final Class<? extends BaseComponent> componentClass;
    private final Class<? extends ComponentFactory> factoryClass;
    private final String widgetModule;
    private final String widgetClass;
    private final String description;
    private final Set<String> parentTags = new HashSet<String>();
    private final Map<String, Cardinality> childTags = new HashMap<String, Cardinality>();
    private final Map<String, Method> getters = new HashMap<String, Method>();
    private final Map<String, Method> setters = new HashMap<String, Method>();
    private final Map<String, Method> parameters = new HashMap<String, Method>();

    public ComponentDefinition(Class<? extends BaseComponent> componentClass) {
        Component annot = componentClass.getAnnotation(Component.class);
        this.componentClass = componentClass;
        this.factoryClass = annot.factoryClass();
        this.widgetModule = annot.widgetModule();
        this.widgetClass = annot.widgetClass();
        this.tag = annot.tag();
        this.contentHandling = annot.content();
        this.description = annot.description();
        for (String string : annot.parentTag()) {
            this.addParentTag(string);
        }
        for (Component.ChildTag childTag : annot.childTag()) {
            this.addChildTag(childTag);
        }
    }

    public Object getProperty(BaseComponent instance, String name) {
        PropertyName pname = new PropertyName(name);
        Method setter = this.setters.get(pname.name);
        Method getter = this.getters.get(pname.name);
        this.assertTrue(getter != null, setter != null ? "Property \"%s\" is write-only" : "Property \"%s\" is not recognized", name);
        try {
            Object[] objectArray;
            if (getter.getParameterCount() == 1) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = pname.qualifier;
            } else {
                objectArray = null;
            }
            return getter.invoke((Object)instance, objectArray);
        }
        catch (Exception e) {
            throw MiscUtil.toUnchecked((Throwable)e);
        }
    }

    public boolean validateAttribute(String name) {
        PropertyName pname = new PropertyName(name);
        return this.setters.get(pname.name) != null || this.getters.get(pname.name) != null || this.parameters.containsKey(name);
    }

    public DeferredInvocation<?> setProperty(BaseComponent instance, String name, Object value) {
        Object[] objectArray;
        PropertyName pname = new PropertyName(name);
        Method setter = this.setters.get(pname.name);
        Method getter = this.getters.get(pname.name);
        if (value instanceof IBinding) {
            this.assertTrue(getter == null || !(value instanceof IBinding.IWriteBinding) || getter.getAnnotation(Component.PropertyGetter.class).bindable(), "Property \"%s\" does not support a write binding", name);
            this.assertTrue(setter == null || !(value instanceof IBinding.IReadBinding) || setter.getAnnotation(Component.PropertySetter.class).bindable(), "Property \"%s\" does not support a read binding", name);
            ((IBinding)value).init(instance, name, getter, setter);
            return null;
        }
        if (setter == null) {
            this.assertTrue(this.parameters.containsKey(name), getter != null ? "Property \"%s\" is read-only" : "Property \"%s\" is not recognized", name);
            return null;
        }
        if (setter.getParameterCount() == 1) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = value;
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = pname.qualifier;
            objectArray = objectArray3;
            objectArray3[1] = value;
        }
        Object[] args = objectArray;
        if (setter.getAnnotation(Component.PropertySetter.class).defer()) {
            return new DeferredInvocation(instance, setter, args);
        }
        ConvertUtil.invokeMethod(instance, setter, args);
        return null;
    }

    private void assertTrue(boolean condition, String message, Object ... args) {
        ComponentException.assertTrue(condition, this.componentClass, message, args);
    }

    public String getTag() {
        return this.tag;
    }

    public Class<? extends BaseComponent> getComponentClass() {
        return this.componentClass;
    }

    public Class<? extends ComponentFactory> getFactoryClass() {
        return this.factoryClass;
    }

    public String getDescription() {
        return this.description;
    }

    public ComponentFactory getFactory() {
        try {
            return (ComponentFactory)ConstructorUtils.invokeConstructor(this.factoryClass, (Object)this);
        }
        catch (Exception e) {
            throw MiscUtil.toUnchecked((Throwable)e);
        }
    }

    public String getWidgetModule() {
        return this.widgetModule;
    }

    public String getWidgetClass() {
        return this.widgetClass;
    }

    public Cardinality getCardinality(String childTag) {
        Cardinality cardinality = this.childTags.get(childTag);
        return cardinality == null ? this.childTags.get("*") : cardinality;
    }

    public Map<String, Cardinality> getChildTags() {
        return Collections.unmodifiableMap(this.childTags);
    }

    public boolean childrenAllowed() {
        return this.childTags.size() > 0;
    }

    public void validateChild(ComponentDefinition childDefinition, IntSupplier childCount) {
        this.assertTrue(this.childrenAllowed(), "Children are not allowed", new Object[0]);
        childDefinition.validateParent(this);
        Cardinality cardinality = this.getCardinality(childDefinition.tag);
        this.assertTrue(cardinality != null, "%s is not a valid child", childDefinition.componentClass);
        this.assertTrue(!cardinality.hasMaximum() || childCount.getAsInt() < cardinality.getMaximum(), "A maximum of %d children of type %s are allowed", cardinality.getMaximum(), childDefinition.componentClass);
    }

    public void validateParent(ComponentDefinition parentDefinition) {
        this.assertTrue(this.isParentTag(parentDefinition.tag), "%s is not a valid parent", parentDefinition.componentClass);
    }

    public boolean isParentTag(String tag) {
        return this.parentTags.contains(tag) || this.parentTags.contains("*");
    }

    public Set<String> getParentTags() {
        return Collections.unmodifiableSet(this.parentTags);
    }

    public Component.ContentHandling contentHandling() {
        return this.contentHandling;
    }

    private void addParentTag(String tag) {
        this.parentTags.add(tag);
    }

    private void addChildTag(Component.ChildTag tag) {
        this.childTags.put(tag.value(), new Cardinality(tag.minimum(), tag.maximum()));
    }

    private boolean isStatic(Method method) {
        return Modifier.isStatic(method.getModifiers());
    }

    void _addGetter(Method method) {
        String name;
        Component.PropertyGetter getter = method.getAnnotation(Component.PropertyGetter.class);
        if (getter != null && !this.getters.containsKey(name = getter.value())) {
            if (this.isStatic(method) || method.getReturnType() == Void.TYPE || method.getParameterTypes().length > 0) {
                throw new IllegalArgumentException("Bad signature for getter method: " + method.getName());
            }
            this.getters.put(name, getter.hide() ? null : method);
        }
    }

    public Map<String, Method> getGetters() {
        return Collections.unmodifiableMap(this.getters);
    }

    void _addSetter(Method method) {
        String name;
        Component.PropertySetter setter = method.getAnnotation(Component.PropertySetter.class);
        if (setter != null && !this.setters.containsKey(name = setter.value())) {
            int length = method.getParameterCount();
            if (this.isStatic(method) || length == 0 || length > 2 || length == 2 && method.getParameterTypes()[0] != String.class) {
                throw new IllegalArgumentException("Bad signature for setter method: " + method.getName());
            }
            this.setters.put(name, setter.hide() ? null : method);
        }
    }

    public Map<String, Method> getSetters() {
        return Collections.unmodifiableMap(this.setters);
    }

    void _addFactoryParameter(Method method) {
        String name;
        Component.FactoryParameter parameter = method.getAnnotation(Component.FactoryParameter.class);
        if (parameter != null && !this.parameters.containsKey(name = parameter.value())) {
            if (this.isStatic(method) || method.getParameterTypes().length != 1) {
                throw new IllegalArgumentException("Bad signature for factory parameter method: " + method.getName());
            }
            this.parameters.put(name, method);
        }
    }

    public Map<String, Method> getFactoryParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public boolean equals(Object object) {
        return object instanceof ComponentDefinition && ((ComponentDefinition)object).componentClass == this.componentClass;
    }

    private static class PropertyName {
        private final String name;
        private final String qualifier;

        PropertyName(String value) {
            if (!value.contains(":")) {
                this.name = value;
                this.qualifier = value;
            } else {
                String[] pcs = value.split("\\:", 2);
                this.name = pcs[0] + ":";
                this.qualifier = pcs[1];
            }
        }
    }

    public static class Cardinality {
        private final int minimum;
        private final int maximum;

        Cardinality(int minimum, int maximum) {
            this.minimum = minimum;
            this.maximum = maximum;
        }

        public int getMinimum() {
            return this.minimum;
        }

        public int getMaximum() {
            return this.maximum;
        }

        public boolean hasMinimum() {
            return this.minimum > 0;
        }

        public boolean hasMaximum() {
            return this.maximum != Integer.MAX_VALUE;
        }

        public boolean isValid(int count) {
            return count >= this.minimum && count <= this.maximum;
        }
    }
}

