/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.annotation;

import org.fujion.common.Logger;
import org.fujion.common.MiscUtil;
import org.fujion.common.StrUtil;

public enum OnFailure {
    IGNORE,
    EXCEPTION,
    LOG;

    private final Logger log = Logger.create(OnFailure.class);

    void doAction(String message, Object ... args) {
        switch (this) {
            case IGNORE: {
                return;
            }
            case EXCEPTION: {
                message = StrUtil.formatMessage((String)message, (Object[])args);
                throw new RuntimeException(message);
            }
            case LOG: {
                message = StrUtil.formatMessage((String)message, (Object[])args);
                this.log.warn((Object)message);
                return;
            }
        }
    }

    void doAction(Exception e) {
        switch (this) {
            case IGNORE: {
                return;
            }
            case EXCEPTION: {
                throw MiscUtil.toUnchecked((Throwable)e);
            }
            case LOG: {
                this.log.error(() -> e.getMessage(), (Throwable)e);
                return;
            }
        }
    }
}

