/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.annotation;

import java.util.Collection;
import java.util.Map;
import org.fujion.ancillary.ConvertUtil;
import org.fujion.ancillary.IOptionMapTransform;
import org.fujion.ancillary.OptionMap;
import org.fujion.annotation.AbstractFieldScanner;
import org.fujion.annotation.Option;
import org.fujion.common.Logger;
import org.fujion.expression.ELEvaluator;

public class OptionScanner
extends AbstractFieldScanner<Object, Option> {
    private static final Logger log = Logger.create(OptionScanner.class);
    private static final OptionScanner instance = new OptionScanner();

    public static void scan(Object object, OptionMap map) {
        instance.scan(object, (annotation, field) -> {
            try {
                if (annotation.ignore()) {
                    return true;
                }
                String name = annotation.value();
                name = name.isEmpty() ? field.getName() : name;
                Object value = field.get(object);
                if (value == null) {
                    return true;
                }
                if (name.contains("${")) {
                    name = instance.convertWith(value, name).toString();
                }
                if (value instanceof IOptionMapTransform) {
                    value = ((IOptionMapTransform)value).toMap();
                }
                if (value instanceof Collection && ((Collection)value).isEmpty()) {
                    return true;
                }
                if (value instanceof Map && ((Map)value).isEmpty()) {
                    return true;
                }
                if (annotation.convertTo() != Object.class) {
                    value = ConvertUtil.convert(value, annotation.convertTo());
                }
                if (!annotation.convertUsing().isEmpty()) {
                    value = instance.convertWith(value, annotation.convertUsing());
                }
                instance.setValue(name, value, map);
            }
            catch (Exception e) {
                log.error((Object)"Exception transforming option map.", (Throwable)e);
            }
            return true;
        });
    }

    private OptionScanner() {
        super(Object.class, Option.class);
    }

    private void setValue(String name, Object value, Map<String, Object> map) {
        if (name.contains(".")) {
            String[] pcs = name.split("\\.", 2);
            name = pcs[0];
            String rest = pcs[1];
            if (!rest.isEmpty()) {
                Map<String, Object> submap = (Map<String, Object>)map.get(name);
                Map<String, Object> newmap = submap == null ? new OptionMap() : submap;
                this.setValue(rest, value, newmap);
                if (submap == null && !newmap.isEmpty()) {
                    map.put(name, newmap);
                }
            }
            return;
        }
        map.put(name, value);
    }

    private Object convertWith(Object value, String expression) {
        if (!expression.contains("${")) {
            expression = "${" + expression + "}";
        }
        return ELEvaluator.getInstance().evaluate(expression, new ValueWrapper(value));
    }

    private static class ValueWrapper {
        private final Object value;

        ValueWrapper(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

