/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.annotation;

import java.util.ArrayList;
import java.util.List;
import org.fujion.common.Logger;
import org.fujion.common.MiscUtil;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class PackageScanner {
    private static final Logger log = Logger.create(PackageScanner.class);
    private final ResourcePatternResolver resolver;

    public PackageScanner() {
        this((ResourcePatternResolver)new PathMatchingResourcePatternResolver());
    }

    public PackageScanner(ResourcePatternResolver resolver) {
        this.resolver = resolver;
    }

    public List<Class<?>> getClasses(Package pkg) {
        return this.getClasses(pkg.getName());
    }

    public List<Class<?>> getClasses(String pattern) {
        try {
            ArrayList classes = new ArrayList();
            for (Resource resource : this.resolver.getResources("classpath*:" + pattern.replace(".", "/") + "/*.class")) {
                try {
                    String path = resource.getURL().getPath();
                    int i = path.lastIndexOf(".jar!/") + 6;
                    i = i > 5 ? i : path.lastIndexOf("classes/") + 8;
                    int j = path.lastIndexOf(".class");
                    path = path.substring(i, j).replace("/", ".");
                    Class<?> clazz = Class.forName(path);
                    classes.add(clazz);
                }
                catch (Exception e) {
                    log.warn(() -> "Failed to extract class from resource " + resource, (Throwable)e);
                }
            }
            return classes;
        }
        catch (Exception e) {
            throw MiscUtil.toUnchecked((Throwable)e);
        }
    }
}

