/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.annotation;

import org.fujion.annotation.AbstractFieldScanner;
import org.fujion.annotation.OnFailure;
import org.fujion.annotation.WiredComponent;
import org.fujion.common.MiscUtil;
import org.fujion.component.BaseComponent;

public class WiredComponentScanner
extends AbstractFieldScanner<Object, WiredComponent> {
    private static final WiredComponentScanner instance = new WiredComponentScanner();
    private static final String[] DEFAULT_MODE = new String[]{""};

    private WiredComponentScanner() {
        super(Object.class, WiredComponent.class);
    }

    public static void wire(Object object, BaseComponent root, String ... mode) {
        String[] activeModes = mode == null || mode.length == 0 ? DEFAULT_MODE : mode;
        instance.scan(object, (annotation, field) -> {
            if (!MiscUtil.intersects((Object[])annotation.mode(), (Object[])activeModes)) {
                return true;
            }
            OnFailure onFailure = annotation.onFailure();
            if (!BaseComponent.class.isAssignableFrom(field.getType())) {
                onFailure.doAction("Field \"%s\" is not a component type", field.getName());
                return true;
            }
            try {
                if (!annotation.overwrite() && field.get(object) != null) {
                    onFailure.doAction("Field \"%s\" is already assigned a value", field.getName());
                    return true;
                }
                String name = annotation.value();
                name = name.isEmpty() ? field.getName() : name;
                BaseComponent component = root.findByName(name);
                if (component == null) {
                    onFailure.doAction("No component matching name \"%s\"", name);
                    return true;
                }
                field.set(object, component);
            }
            catch (Exception e) {
                onFailure.doAction(e);
            }
            return true;
        });
    }
}

