/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.component;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.reflect.FieldUtils;
import org.fujion.ancillary.ComponentException;
import org.fujion.ancillary.ComponentRegistry;
import org.fujion.ancillary.ConvertUtil;
import org.fujion.ancillary.IAutoWired;
import org.fujion.ancillary.IComposite;
import org.fujion.ancillary.IElementIdentifier;
import org.fujion.ancillary.ILabeled;
import org.fujion.ancillary.INamespace;
import org.fujion.ancillary.IResponseCallback;
import org.fujion.ancillary.OptionMap;
import org.fujion.annotation.Component;
import org.fujion.annotation.ComponentDefinition;
import org.fujion.annotation.EventHandler;
import org.fujion.annotation.EventHandlerScanner;
import org.fujion.annotation.WiredComponentScanner;
import org.fujion.client.ClientInvocation;
import org.fujion.client.ClientInvocationQueue;
import org.fujion.client.ClientUtil;
import org.fujion.client.ExecutionContext;
import org.fujion.common.IAttributeMap;
import org.fujion.common.MiscUtil;
import org.fujion.component.BaseScriptComponent;
import org.fujion.component.Page;
import org.fujion.component.ServerScript;
import org.fujion.event.Event;
import org.fujion.event.EventListeners;
import org.fujion.event.EventUtil;
import org.fujion.event.ForwardListener;
import org.fujion.event.IEventListener;
import org.fujion.event.PropertychangeEvent;
import org.fujion.event.StatechangeEvent;
import org.fujion.model.IBinding;
import org.springframework.util.Assert;

public abstract class BaseComponent
implements IElementIdentifier,
IAttributeMap<String, Object> {
    private static final String ATTR_CONTROLLER = "controller";
    private static final Pattern nameValidator = Pattern.compile("^[a-zA-Z$][a-zA-Z_$0-9]*$");
    private String name;
    private String id;
    private boolean dead;
    private Page page;
    private BaseComponent parent;
    private Object data;
    private String content;
    private boolean contentSynced = true;
    private OptionMap inits;
    private ClientInvocationQueue invocationQueue;
    private boolean namespace;
    private List<Object> controllers;
    private final ChildList children = new ChildList(this);
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final EventListeners eventListeners = new EventListeners();
    private final ComponentDefinition componentDefinition;
    private final NameIndex nameIndex = new NameIndex();

    protected static void validate(BaseComponent comp) {
        ComponentException.assertTrue(comp == null || !comp.isDead(), "Component no longer exists: %s", comp);
    }

    public static boolean validateName(String name) {
        return nameValidator.matcher(name).matches();
    }

    protected BaseComponent() {
        this.componentDefinition = ComponentRegistry.getInstance().get(this.getClass());
        this.namespace = this instanceof INamespace;
        EventHandlerScanner.wire((Object)this, this, "init");
    }

    public ComponentDefinition getDefinition() {
        return this.componentDefinition;
    }

    @Component.PropertyGetter(value="name", bindable=false, description="The name associated with this component instance (must be unique within the enclosing namespace).")
    public String getName() {
        return this.name;
    }

    @Component.PropertySetter(value="name", bindable=false, description="The name associated with this component instance (must be unique within the enclosing namespace).")
    public void setName(String name) {
        if (!this.areEqual(name = this.nullify(name), this.name)) {
            this._validateName(name);
            this.nameIndex.remove(this);
            this.name = name;
            this.propertyChange("name", this.name, this.name, true);
            this.nameIndex.add(this);
        }
    }

    private void _validateName(String name) {
        if (name != null) {
            ComponentException.assertTrue(BaseComponent.validateName(name), this, "Component name \"%s\" is not valid", name);
            this.nameIndex.validate(name);
        }
    }

    @Override
    @Component.PropertyGetter(value="id", description="The unique id of the client widget corresponding to this component.")
    public String getId() {
        return this.id;
    }

    void _setId(String id) {
        Assert.isNull((Object)this.id, () -> "Unique id cannot be modified");
        this.id = id;
    }

    public void detach() {
        this.setParent(null);
    }

    public void detachChildren() {
        this.children.clear();
    }

    public void destroy() {
        if (this.dead) {
            return;
        }
        this.onDestroy();
        if (this.page != null) {
            this.page.registerComponent(this, false);
        }
        this.destroyChildren();
        if (this.parent != null) {
            this.parent.children.remove(this, false, true);
        } else {
            this.invokeIfAttached("destroy", new Object[0]);
        }
        this.dead = true;
        this.fireEvent(new Event("destroy", this));
        this.eventListeners.removeAll();
    }

    public void finalize() throws Throwable {
        super.finalize();
        if (this.id != null) {
            this.destroy();
        }
    }

    public void destroyChildren() {
        this.children.clear(true);
    }

    protected void onDestroy() {
    }

    public boolean isDead() {
        return this.dead;
    }

    public boolean isRendered() {
        return this.page != null && this.page.getId() != null;
    }

    protected void validate() {
        BaseComponent.validate(this);
    }

    public BaseComponent getParent() {
        return this.parent;
    }

    protected void validateParent(BaseComponent parent) {
        if (parent == null) {
            return;
        }
        this.componentDefinition.validateParent(parent.componentDefinition);
        ComponentException.assertTrue(!this.isAncestor(parent), "Not a valid parent because it is the same as or an descendant of this component", new Object[0]);
    }

    public void setParent(BaseComponent parent) {
        if (parent != this.parent) {
            if (parent == null) {
                this.parent.removeChild(this);
            } else {
                parent.addChild(this);
            }
        }
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public <T> T getAttribute(String name, T dflt) {
        try {
            Object value = this.attributes.get(name);
            return (T)(value == null ? dflt : (dflt == null ? value : dflt.getClass().cast(value)));
        }
        catch (Exception e) {
            return dflt;
        }
    }

    public <T> T getAttribute(String name, Class<T> type) {
        try {
            return ConvertUtil.convert(this.attributes.get(name), type, this);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object findAttribute(String name) {
        Object value = null;
        for (BaseComponent cmp = this; cmp != null && (value = cmp.attributes.get(name)) == null; cmp = cmp.getParent()) {
        }
        return value;
    }

    @Component.PropertySetter(value="attr:")
    private Object _setAttribute(String name, Object value) {
        return this.setAttribute(name, value);
    }

    protected void validateIsChild(BaseComponent child) {
        ComponentException.assertTrue(child == null || child.getParent() == this, child, "Child does not belong to this parent", new Object[0]);
    }

    protected void validateChild(BaseComponent child) {
        this.componentDefinition.validateChild(child.componentDefinition, () -> this.getChildCount(child.getClass()));
    }

    public void addChild(BaseComponent child) {
        this.children.add(-1, child);
    }

    public void addChild(BaseComponent child, int index) {
        this.children.add(index, child);
    }

    public void addChild(BaseComponent child, BaseComponent before) {
        if (before == null) {
            this.children.add(-1, child);
        } else {
            ComponentException.assertTrue(before.getParent() == this, this, "Reference component does not belong to this parent", new Object[0]);
            int i = this.children.indexOf(before);
            this.children.add(i, child);
        }
    }

    public void addChildren(Collection<? extends BaseComponent> children) {
        this.children.addAll(children);
    }

    public void removeChild(BaseComponent child) {
        this.children.remove(child);
    }

    public void swapChildren(int index1, int index2) {
        this.children.swap(index1, index2);
    }

    public void addComposite(IComposite composite) {
        BaseComponent root = composite.getCompositeRoot();
        Assert.notNull((Object)root, () -> "A snippet must specify a root");
        String anchorName = composite.getCompositeAnchor();
        IComposite.CompositePosition position = composite.getCompositePosition();
        Assert.notNull((Object)((Object)position), () -> "A snippet must specify a position");
        BaseComponent anchor = anchorName == null ? this : this.findByName(anchorName);
        Assert.notNull((Object)anchor, () -> "Could not locate any anchor named " + anchorName);
        BaseComponent parent = position == IComposite.CompositePosition.FIRST || position == IComposite.CompositePosition.LAST ? anchor : anchor.getParent();
        Assert.notNull((Object)parent, () -> "Anchor must have a parent for position value of " + (Object)((Object)position));
        root.detach();
        int index = anchor.getIndex();
        switch (position) {
            case FIRST: {
                parent.addChild(root, 0);
                break;
            }
            case LAST: {
                parent.addChild(root, -1);
                break;
            }
            case PARENT: {
                anchor.detach();
                parent.addChild(root, index);
                anchor.setParent(root);
                break;
            }
            case REPLACE: {
                anchor.destroy();
                parent.addChild(root, index);
                break;
            }
            case BEFORE: {
                parent.addChild(root, index);
                break;
            }
            case AFTER: {
                parent.addChild(root, index + 1);
            }
        }
    }

    protected void beforeSetParent(BaseComponent newParent) {
    }

    protected void afterSetParent(BaseComponent oldParent) {
    }

    protected void beforeAddChild(BaseComponent child) {
    }

    protected void afterAddChild(BaseComponent child) {
    }

    protected void beforeRemoveChild(BaseComponent child) {
    }

    protected void afterRemoveChild(BaseComponent child) {
    }

    public final List<BaseComponent> getChildren() {
        return this.children;
    }

    public final <T extends BaseComponent> Iterable<T> getChildren(Class<T> type) {
        return MiscUtil.iterableForType(this.getChildren(), type);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public int getChildCount(Class<? extends BaseComponent> type) {
        int count = 0;
        for (BaseComponent child : this.children) {
            if (!type.isInstance(child)) continue;
            ++count;
        }
        return count;
    }

    public boolean isContainer() {
        return this.componentDefinition.childrenAllowed();
    }

    public <T extends BaseComponent> T getChild(Class<T> type) {
        for (BaseComponent child : this.children) {
            if (!type.isInstance(child)) continue;
            return (T)child;
        }
        return null;
    }

    public BaseComponent getChildAt(int index) {
        return index < 0 || index >= this.getChildCount() ? null : this.children.get(index);
    }

    public BaseComponent getFirstChild() {
        return this.getChildAt(0);
    }

    public BaseComponent getLastChild() {
        return this.getChildAt(this.getChildCount() - 1);
    }

    public BaseComponent getRoot() {
        BaseComponent root = this;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        return root;
    }

    public <T extends BaseComponent> T getAncestor(Class<T> type) {
        return (T)((BaseComponent)this.getAncestor(type, false));
    }

    public <T> T getAncestor(Class<T> type, boolean includeSelf) {
        BaseComponent cmp;
        BaseComponent baseComponent = cmp = includeSelf ? this : this.getParent();
        while (cmp != null && !type.isInstance(cmp)) {
            cmp = cmp.getParent();
        }
        return (T)cmp;
    }

    public boolean isAncestor(BaseComponent comp) {
        while (comp != null && comp != this) {
            comp = comp.getParent();
        }
        return comp != null;
    }

    public int getIndex() {
        return this.getParent() == null ? -1 : this.getParent().children.indexOf(this);
    }

    public void setIndex(int index) {
        this.getParent().addChild(this, index);
    }

    public BaseComponent getNextSibling() {
        return this.getRelativeSibling(1);
    }

    public BaseComponent getPreviousSibling() {
        return this.getRelativeSibling(-1);
    }

    private BaseComponent getRelativeSibling(int offset) {
        int i = this.getIndex();
        i = i == -1 ? -1 : i + offset;
        return i < 0 || i >= this.getParent().getChildCount() ? null : this.getParent().getChildAt(i);
    }

    public BaseComponent getNamespace() {
        for (BaseComponent comp = this; comp != null; comp = comp.getParent()) {
            if (!comp.isNamespace()) continue;
            return comp;
        }
        return null;
    }

    @Component.PropertyGetter(value="namespace", bindable=false, description="When true, this component acts as a namespace boundary.")
    public boolean isNamespace() {
        return this.namespace;
    }

    @Component.PropertySetter(value="namespace", bindable=false, description="When true, this component acts as a namespace boundary.")
    public void setNamespace(boolean namespace) {
        if (this.namespace != namespace) {
            ComponentException.assertTrue(!(this instanceof INamespace), this, "You may not disable namespace support for a component that implements INamespace", new Object[0]);
            ComponentException.assertTrue(this.parent == null && !this.hasChildren(), this, "You may not modify the namespace property if a component has a parent or any children.", new Object[0]);
            this.namespace = namespace;
        }
    }

    public Page getPage() {
        return this.page;
    }

    private void _setPage(Page page) {
        this.validatePage(page);
        this.page = page;
        page.registerComponent(this, true);
        OptionMap props = new OptionMap();
        this._initProps(props);
        page.getSynchronizer().createWidget(this.parent, props, this.inits);
        this.inits = null;
        for (BaseComponent child : this.children) {
            child._setPage(page);
        }
    }

    protected void onAttach(Page page) {
    }

    protected void validatePage(Page page) {
        ComponentException.assertTrue(page == this.page || this.page == null, this, "Component cannot be assigned to a different page", new Object[0]);
    }

    protected void _attach(Page page) {
        if (page != null && this.page != page) {
            this._setPage(page);
            this._flushQueue();
        }
    }

    private void _flushQueue() {
        if (this.invocationQueue != null) {
            this.page.getSynchronizer().processQueue(this.invocationQueue);
            this.invocationQueue = null;
        }
        for (BaseComponent child : this.children) {
            child._flushQueue();
        }
        this.onAttach(this.page);
        this.fireEvent("attach");
    }

    protected void _initProps(Map<String, Object> props) {
        props.put("id", this.id);
        props.put("wclass", this.componentDefinition.getWidgetClass());
        props.put("wmodule", this.componentDefinition.getWidgetModule());
        props.put("cntr", this.isContainer());
        props.put("nmsp", this.isNamespace() ? Boolean.valueOf(true) : null);
    }

    protected void sync(String state, Object value) {
        if (!this.dead) {
            if (this.getPage() == null) {
                if (this.inits == null) {
                    this.inits = new OptionMap();
                }
                this.inits.put(state, value);
            } else {
                this.page.getSynchronizer().invokeClient((IElementIdentifier)this, "updateState", state, value, true);
            }
        }
    }

    public void invoke(String function, Object ... args) {
        this.invoke(function, null, args);
    }

    public void invoke(String function, IResponseCallback<?> callback, Object ... args) {
        if (!this.dead) {
            this.invoke((IElementIdentifier)this, function, callback, args);
        }
    }

    public void invokeIfAttached(String function, Object ... args) {
        if (this.page != null) {
            this.invoke(function, null, args);
        }
    }

    public void invoke(ClientInvocation invocation) {
        if (this.page == null) {
            if (this.invocationQueue == null) {
                this.invocationQueue = new ClientInvocationQueue();
            }
            this.invocationQueue.queue(invocation);
        } else {
            this.page.getSynchronizer().sendToClient(invocation);
        }
    }

    public void invoke(IElementIdentifier id, String function, IResponseCallback<?> callback, Object ... args) {
        this.invoke(new ClientInvocation(id, function, callback, args));
    }

    public void invoke(IElementIdentifier id, String function, Object ... args) {
        this.invoke(id, function, null, args);
    }

    public BaseComponent findByName(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        String[] pcs = name.replace('.', '/').split("\\/");
        BaseComponent cmp = this;
        int i = 0;
        while (i < pcs.length && cmp != null) {
            String pc;
            if ((pc = pcs[i++]).isEmpty()) continue;
            if ("^".equals(pc)) {
                cmp = cmp.getNamespace();
                if (i == pcs.length) continue;
                cmp = cmp == null ? null : cmp.getParent();
                cmp = cmp == null ? null : cmp.getNamespace();
                continue;
            }
            cmp = cmp.nameIndex.find(pc);
        }
        return cmp;
    }

    public Map<String, BaseComponent> findAllNamed() {
        return this.nameIndex.findAll();
    }

    public <T extends BaseComponent> T findByName(String name, Class<T> type) {
        return (T)this.findByName(name);
    }

    public BaseComponent findChildByData(Object data) {
        for (BaseComponent child : this.children) {
            if (!ObjectUtils.equals((Object)data, (Object)child.getData())) continue;
            return child;
        }
        return null;
    }

    public BaseComponent findChildByLabel(String label) {
        for (BaseComponent comp : this.children) {
            if (!(comp instanceof ILabeled) || !label.equals(((ILabeled)((Object)comp)).getLabel())) continue;
            return comp;
        }
        return null;
    }

    public SubComponent sub(String subId) {
        return new SubComponent(this, subId);
    }

    @Component.PropertySetter(value="forward", bindable=false, defer=true, description="Sets one or more event forwarding directives.")
    private void setForward(String forwards) {
        if ((forwards = this.trimify(forwards)) != null) {
            for (String forward : forwards.split("\\ ")) {
                if (forward.isEmpty()) continue;
                int i = forward.indexOf("=");
                if (i <= 0) {
                    throw new IllegalArgumentException("Illegal forward directive:  " + forward);
                }
                String original = forward.substring(0, i);
                String name = (i = (forward = forward.substring(i + 1)).lastIndexOf(".")) == -1 ? null : forward.substring(0, i);
                forward = forward.substring(i + 1);
                BaseComponent target = name == null ? this : this.findByName(name);
                ComponentException.assertTrue(target != null, this, "No component named \"%s\" found", name);
                ComponentException.assertTrue(!forward.isEmpty(), this, "No forward event specified", new Object[0]);
                this.addEventForward(original, target, forward);
            }
        }
    }

    public void addEventForward(String eventType, BaseComponent target) {
        this.addEventForward(eventType, target, null);
    }

    public void addEventForward(String eventType, BaseComponent target, String forwardType) {
        this.addEventListener(eventType, (IEventListener)this.createForwardListener(eventType, target, forwardType));
    }

    public void addEventForward(Class<? extends Event> eventClass, BaseComponent target) {
        this.addEventForward(eventClass, target, null);
    }

    public void addEventForward(Class<? extends Event> eventClass, BaseComponent target, String forwardType) {
        this.addEventForward(this.getEventType(eventClass), target, forwardType);
    }

    public void removeEventForward(String eventType, BaseComponent target) {
        this.removeEventForward(eventType, target, null);
    }

    public void removeEventForward(String eventType, BaseComponent target, String forwardType) {
        this.removeEventListener(eventType, (IEventListener)this.createForwardListener(eventType, target, forwardType));
    }

    public void removeEventForward(Class<? extends Event> eventClass, BaseComponent target) {
        this.removeEventForward(eventClass, target, null);
    }

    public void removeEventForward(Class<? extends Event> eventClass, BaseComponent target, String forwardType) {
        this.removeEventForward(this.getEventType(eventClass), target, forwardType);
    }

    private ForwardListener createForwardListener(String eventType, BaseComponent target, String forwardType) {
        return new ForwardListener(forwardType == null ? eventType : forwardType, target == null ? this : target);
    }

    public boolean hasEventListener(String eventType) {
        return this.eventListeners.hasListeners(eventType);
    }

    public boolean hasEventListener(Class<? extends Event> eventClass) {
        return this.hasEventListener(this.getEventType(eventClass));
    }

    public void addEventListener(String eventType, IEventListener eventListener) {
        this.updateEventListener(eventType, eventListener, true, true);
    }

    public void addEventListener(Class<? extends Event> eventClass, IEventListener eventListener) {
        this.updateEventListener(eventClass, eventListener, true, true);
    }

    public void addEventListener(String eventType, IEventListener eventListener, boolean syncToClient) {
        this.updateEventListener(eventType, eventListener, true, syncToClient);
    }

    public void addEventListener(Class<? extends Event> eventClass, IEventListener eventListener, boolean syncToClient) {
        this.updateEventListener(eventClass, eventListener, true, syncToClient);
    }

    public void removeEventListener(String eventType, IEventListener eventListener) {
        this.updateEventListener(eventType, eventListener, false, true);
    }

    public void removeEventListener(Class<? extends Event> eventClass, IEventListener eventListener) {
        this.updateEventListener(eventClass, eventListener, false, true);
    }

    public void removeEventListener(String eventType, IEventListener eventListener, boolean syncToClient) {
        this.updateEventListener(eventType, eventListener, false, syncToClient);
    }

    public void removeEventListener(Class<? extends Event> eventClass, IEventListener eventListener, boolean syncToClient) {
        this.updateEventListener(eventClass, eventListener, false, syncToClient);
    }

    private void updateEventListener(Class<? extends Event> eventClass, IEventListener eventListener, boolean register, boolean syncToClient) {
        this.updateEventListener(this.getEventType(eventClass), eventListener, register, syncToClient);
    }

    private void updateEventListener(String eventTypes, IEventListener eventListener, boolean register, boolean syncToClient) {
        for (String eventType : eventTypes.split("\\ ")) {
            eventType = EventUtil.stripOn(eventType);
            boolean before = this.eventListeners.hasListeners(eventType);
            if (register) {
                this.eventListeners.add(eventType, eventListener);
            } else {
                this.eventListeners.remove(eventType, eventListener);
            }
            if (!syncToClient || before == this.eventListeners.hasListeners(eventType)) continue;
            this.syncEventListeners(eventType, before);
        }
    }

    private void syncEventListeners(String eventType, boolean remove) {
        this.invoke("forwardToServer", eventType, remove);
    }

    private String getEventType(Class<? extends Event> eventClass) {
        String eventType = EventUtil.getEventType(eventClass);
        if (eventType == null) {
            throw new IllegalArgumentException("Not a concrete event type: " + eventClass);
        }
        return eventType;
    }

    public void fireEvent(String eventType) {
        this.fireEvent(EventUtil.toEvent(eventType, this, null));
    }

    public void fireEvent(Event event) {
        this.eventListeners.invoke(event);
    }

    public void fireEventToClient(String eventType, Object data) {
        this.fireEventToClient(eventType, this, data);
    }

    public void fireEventToClient(String eventType, IElementIdentifier target, Object data) {
        OptionMap event = new OptionMap();
        event.put("type", (Object)eventType);
        event.put("data", data);
        event.put("target", (Object)target);
        this.invoke("trigger", event, null, true);
    }

    @Component.PropertySetter(value="on:")
    private void setOnHandler(String eventName, Object value) {
        BaseScriptComponent script;
        if (value instanceof IEventListener) {
            this.addEventListener(eventName, (IEventListener)value);
            return;
        }
        if (value instanceof BaseScriptComponent) {
            script = (BaseScriptComponent)value;
        } else if (value instanceof String) {
            script = new ServerScript("groovy", value.toString());
            script.setMode(BaseScriptComponent.ExecutionMode.MANUAL);
            script.setSelf(this);
        } else {
            throw new ComponentException(this, "Illegal type (%s) for event handler \"%s\"", value.getClass(), eventName);
        }
        this.addEventListener(eventName, (Event event) -> {
            if (script.getPage() == null) {
                script.setParent(this.getPage());
            } else {
                script.validatePage(this.getPage());
            }
            HashMap<String, Object> variables = new HashMap<String, Object>();
            variables.put(script.getSelfName(), this);
            variables.put(ATTR_CONTROLLER, this.findAttribute(ATTR_CONTROLLER));
            variables.put("event", event);
            script.execute(variables);
        });
    }

    public void notifyAncestors(Event event, boolean includeThis) {
        BaseComponent next;
        BaseComponent baseComponent = next = includeThis ? this : this.getParent();
        while (next != null && !event.isStopped()) {
            next.fireEvent(event);
            next = next.getParent();
        }
    }

    public void notifyDescendants(Event event, boolean includeThis) {
        for (BaseComponent child : this.children) {
            child.notifyDescendants(event, true);
        }
        if (includeThis && !event.isStopped()) {
            this.fireEvent(event);
        }
    }

    @Component.PropertySetter(value="controller", bindable=false, defer=true, description="Controller to be wired to this component.")
    public void wireController(Object controller) {
        this.wireController("", controller);
    }

    @Component.PropertySetter(value="controller:", bindable=false, defer=true, description="Controller to be wired to this component.")
    public void wireController(String mode, Object controller) {
        ComponentException.assertTrue(controller != null, this, "Controller is null or could not be resolved", new Object[0]);
        if (controller instanceof Collection) {
            for (Object ctlr : (Collection)controller) {
                this.wireController(mode, ctlr);
            }
            return;
        }
        if (controller instanceof String) {
            try {
                controller = "self".equals(controller) ? this : Class.forName((String)controller);
            }
            catch (Exception e) {
                throw MiscUtil.toUnchecked((Throwable)e);
            }
        }
        if (controller instanceof Class) {
            try {
                controller = ((Class)controller).newInstance();
            }
            catch (Exception e) {
                throw MiscUtil.toUnchecked((Throwable)e);
            }
        }
        this.setAttribute(ATTR_CONTROLLER, controller);
        if (controller instanceof IAutoWired) {
            ((IAutoWired)controller).beforeInitialized(this);
        }
        WiredComponentScanner.wire(controller, this, mode);
        EventHandlerScanner.wire(controller, this, mode);
        this.controllers = this.controllers == null ? new ArrayList() : this.controllers;
        this.controllers.add(controller);
        this.setAttribute("controller_" + this.controllers.size(), controller);
        if (controller instanceof IAutoWired) {
            ((IAutoWired)controller).afterInitialized(this);
        }
    }

    public List<Object> getControllers() {
        return this.controllers == null ? Collections.emptyList() : Collections.unmodifiableList(this.controllers);
    }

    @Deprecated
    public Object getController() {
        return this.getLastController();
    }

    public Object getLastController() {
        return this.controllers == null ? null : this.controllers.get(this.controllers.size() - 1);
    }

    public void bringToFront() {
        if (this.getParent() != null) {
            this.getParent().bringToFront();
        }
    }

    protected String nullify(String value) {
        return value == null || value.isEmpty() ? null : value;
    }

    protected String trimify(String value) {
        return value == null ? null : this.nullify(value.trim());
    }

    protected <T> T defaultify(T value, T deflt) {
        return value == null ? deflt : value;
    }

    protected boolean areEqual(Object obj1, Object obj2) {
        return ObjectUtils.equals((Object)obj1, (Object)obj2);
    }

    @Component.PropertyGetter(value="data", description="Data object to associate with this component.")
    public Object getData() {
        return this.data;
    }

    public <T> T getData(Class<T> type) {
        return (T)(type.isInstance(this.data) ? this.data : null);
    }

    @Component.PropertySetter(value="data", description="Data object to associate with this component.")
    public void setData(Object data) {
        this.data = data;
        this.propertyChange("data", this.data, this.data, false);
    }

    @Component.PropertyGetter(value="#text")
    protected String getContent() {
        return this.content;
    }

    @Component.PropertySetter(value="#text")
    protected void setContent(String content) {
        this.content = this.nullify(content);
        this.propertyChange("content", this.content, this.content, this.contentSynced);
    }

    protected boolean isContentSynced() {
        return this.contentSynced;
    }

    protected void setContentSynced(boolean contentSynced) {
        this.contentSynced = contentSynced;
    }

    @EventHandler(value={"statechange"}, syncToClient=false, mode={"init"})
    private void _onStateChange(StatechangeEvent event) {
        String state = event.getState();
        try {
            Field field = FieldUtils.getField(this.getClass(), (String)state, (boolean)true);
            Object oldValue = field.get(this);
            Object newValue = ConvertUtil.convert(event.getValue(), field.getType(), this);
            field.set(this, newValue);
            this.propertyChange(state, oldValue, newValue, false);
        }
        catch (Exception e) {
            throw new ComponentException((Throwable)e, this, "Error updating state \"%s\"", state);
        }
    }

    protected boolean propertyChange(String propertyName, Object oldValue, Object newValue, boolean syncToClient) {
        if (this.areEqual(oldValue, newValue)) {
            return false;
        }
        if (syncToClient) {
            this.sync(propertyName, newValue);
        }
        if (this.hasEventListener("propertychange")) {
            this.fireEvent(new PropertychangeEvent(this, propertyName, oldValue, newValue));
        }
        return true;
    }

    protected <T extends BaseComponent> boolean propertyChange(String propertyName, ComponentReference<T> reference, T newValue, boolean syncToClient) {
        T oldValue = reference.getReference();
        if (reference.setReference(newValue)) {
            this.propertyChange(propertyName, oldValue, newValue, false);
            if (syncToClient) {
                this.sync(propertyName, reference);
            }
            return true;
        }
        return false;
    }

    public void bind(String propertyName, IBinding binding) {
        this.getDefinition().setProperty(this, propertyName, binding);
    }

    public void loadModule(String module) {
        this.loadModule(module, null);
    }

    public void loadModule(String module, IResponseCallback<?> callback) {
        ClientUtil.invoke(new ClientInvocation(module, "", callback, new Object[0]));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(this.getClass().getName()).append(", ").append("id: ").append(this.id).append(", ").append("name: ").append(this.name);
        return sb.toString();
    }

    private class NameIndex {
        private Map<String, BaseComponent> names;

        private NameIndex() {
        }

        public void add(BaseComponent component) {
            String name = component.getName();
            if (name != null) {
                this.names = this.names == null ? new HashMap() : this.names;
                this.names.put(name, component);
            }
        }

        public void remove(BaseComponent component) {
            String name = component.getName();
            if (name != null && this.names != null) {
                this.names.remove(name);
            }
        }

        private BaseComponent _get(String name) {
            return this.names == null ? null : this.names.get(name);
        }

        public void validate(BaseComponent component) {
            this._validate(component, this.getNameRoot());
        }

        private void _validate(BaseComponent component, BaseComponent root) {
            this._validate(component.getName(), root, component);
            if (!component.isNamespace()) {
                for (BaseComponent child : component.children) {
                    this._validate(child, root);
                }
            }
        }

        private void validate(String name) {
            this._validate(name, this.getNameRoot(), null);
        }

        private void _validate(String name, BaseComponent root, BaseComponent component) {
            if (name != null) {
                BaseComponent cmp = this._find(name, root);
                ComponentException.assertTrue(cmp == null || cmp == component, "Name \"%s\"already exists in enclosing namespace", name);
            }
        }

        private BaseComponent getNameRoot() {
            BaseComponent root = BaseComponent.this.getNamespace();
            return root == null ? BaseComponent.this.getRoot() : root;
        }

        public BaseComponent find(String name) {
            return this._find(name, this.getNameRoot());
        }

        private BaseComponent _find(String name, BaseComponent root) {
            BaseComponent component = root.nameIndex._get(name);
            if (component != null) {
                return component;
            }
            for (BaseComponent child : root.children) {
                if (!child.isNamespace() && (component = this._find(name, child)) != null) break;
            }
            return component;
        }

        public Map<String, BaseComponent> findAll() {
            HashMap<String, BaseComponent> results = new HashMap<String, BaseComponent>();
            this._findAll(this.getNameRoot(), results);
            return results;
        }

        private void _findAll(BaseComponent root, Map<String, BaseComponent> results) {
            if (((BaseComponent)root).nameIndex.names != null) {
                results.putAll(((BaseComponent)root).nameIndex.names);
            }
            for (BaseComponent child : root.children) {
                if (child.isNamespace()) continue;
                this._findAll(child, results);
            }
        }
    }

    private static class ChildList
    implements List<BaseComponent> {
        private final List<BaseComponent> delegate = new LinkedList<BaseComponent>();
        private final BaseComponent parent;
        private int modCount;

        private ChildList(BaseComponent parent) {
            this.parent = parent;
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.delegate.contains(o);
        }

        @Override
        public Iterator<BaseComponent> iterator() {
            return new Iterator<BaseComponent>(){
                int next = 0;
                boolean fetched = false;
                int expected = ChildList.access$100(this);

                @Override
                public boolean hasNext() {
                    this.checkModCount();
                    return this.next < delegate.size();
                }

                @Override
                public BaseComponent next() {
                    this.checkModCount();
                    this.fetched = true;
                    return (BaseComponent)delegate.get(this.next++);
                }

                @Override
                public void remove() {
                    this.checkModCount();
                    Assert.state((boolean)this.fetched, (String)"No element to remove");
                    this.fetched = false;
                    this.remove(--this.next);
                    this.expected = modCount;
                }

                private void checkModCount() {
                    if (modCount != this.expected) {
                        throw new ConcurrentModificationException();
                    }
                }
            };
        }

        @Override
        public Object[] toArray() {
            return this.delegate.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.delegate.toArray(a);
        }

        @Override
        public boolean remove(Object o) {
            this.remove((BaseComponent)o, false, false);
            return true;
        }

        protected void remove(BaseComponent child, boolean noSync, boolean destroy) {
            if (child instanceof IComposite) {
                BaseComponent parent;
                BaseComponent root = ((IComposite)((Object)child)).getCompositeRoot();
                BaseComponent baseComponent = parent = root == null ? null : root.getParent();
                if (parent != null) {
                    parent.children.remove(root, noSync, destroy);
                }
                child.parent = null;
                ++this.modCount;
            } else {
                int index = this.indexOf(child);
                ComponentException.assertTrue(index != -1, this.parent, "Child does not belong to this parent", new Object[0]);
                this.parent.beforeRemoveChild(child);
                this.parent.nameIndex.remove(child);
                child.parent = null;
                this.delegate.remove(child);
                ++this.modCount;
                if (!noSync) {
                    this.parent.invokeIfAttached("removeChild", child, destroy);
                }
                BaseComponent baseComponent = child;
                baseComponent.dead = baseComponent.dead | destroy;
                this.parent.afterRemoveChild(child);
            }
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.delegate.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends BaseComponent> c) {
            return this.addAll(this.delegate.size(), c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends BaseComponent> c) {
            for (BaseComponent baseComponent : c) {
                this.add(index++, baseComponent);
            }
            return true;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            for (Object child : c) {
                this.remove(child);
            }
            return true;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            ArrayList<BaseComponent> remove = new ArrayList<BaseComponent>(this.delegate);
            remove.removeAll(c);
            return this.removeAll(remove);
        }

        @Override
        public void clear() {
            this.clear(false);
        }

        public void clear(boolean destroy) {
            while (!this.isEmpty()) {
                this.remove(this.get(0), false, destroy);
            }
        }

        @Override
        public BaseComponent get(int index) {
            return this.delegate.get(index);
        }

        @Override
        public BaseComponent set(int index, BaseComponent child) {
            BaseComponent old = this.get(index);
            old.detach();
            this.add(index, child);
            return old;
        }

        @Override
        public boolean add(BaseComponent child) {
            this.add(-1, child);
            return true;
        }

        @Override
        public void add(int index, BaseComponent child) {
            ++this.modCount;
            if (child instanceof IComposite) {
                this.parent.addComposite((IComposite)((Object)child));
                child.parent = this.parent;
                return;
            }
            boolean noSync = child.getPage() == null && index < 0;
            child.validate();
            BaseComponent oldParent = child.getParent();
            if (oldParent != this.parent) {
                child.validateParent(this.parent);
                this.parent.validateChild(child);
                this.parent.nameIndex.validate(child);
            }
            child.validatePage(this.parent.page);
            if (oldParent == this.parent) {
                int i = child.getIndex();
                if (i == index) {
                    return;
                }
                if (index > i) {
                    --index;
                }
            } else {
                child.beforeSetParent(this.parent);
                this.parent.beforeAddChild(child);
            }
            if (oldParent != null) {
                oldParent.children.remove(child, true, false);
            }
            if (index < 0) {
                this.delegate.add(child);
            } else {
                this.delegate.add(index, child);
            }
            child.parent = this.parent;
            if (this.parent.page != null) {
                child._attach(this.parent.page);
            }
            this.parent.nameIndex.add(child);
            if (!noSync) {
                this.parent.invokeIfAttached("addChild", child, index);
            }
            if (oldParent != this.parent) {
                this.parent.afterAddChild(child);
                child.afterSetParent(this.parent);
            }
        }

        @Override
        public BaseComponent remove(int index) {
            BaseComponent old = this.get(index);
            this.remove(old);
            return old;
        }

        @Override
        public int indexOf(Object o) {
            return this.delegate.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.delegate.lastIndexOf(o);
        }

        @Override
        public ListIterator<BaseComponent> listIterator() {
            return IteratorUtils.toListIterator(this.iterator());
        }

        @Override
        public ListIterator<BaseComponent> listIterator(int index) {
            ListIterator<BaseComponent> iter = this.listIterator();
            while (iter.nextIndex() < index) {
                iter.next();
            }
            return iter;
        }

        @Override
        public List<BaseComponent> subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException();
        }

        public void swap(int index1, int index2) {
            if (index1 != index2) {
                BaseComponent child1 = this.delegate.get(index1);
                BaseComponent child2 = this.delegate.get(index2);
                this.delegate.set(index1, child2);
                this.delegate.set(index2, child1);
                this.parent.invokeIfAttached("swapChildren", index1, index2);
                ++this.modCount;
            }
        }
    }

    public static class ComponentReference<T extends BaseComponent>
    implements IElementIdentifier,
    IEventListener {
        private T component;
        private final Consumer<BaseComponent> onDestroy;
        final /* synthetic */ BaseComponent this$0;

        public ComponentReference(BaseComponent this$0) {
            this(this$0, null, null);
        }

        public ComponentReference(T component) {
            this(this$0, (BaseComponent)component, null);
        }

        public ComponentReference(BaseComponent this$0, Consumer<BaseComponent> onDestroy) {
            this(this$0, null, onDestroy);
        }

        public ComponentReference(T component, Consumer<BaseComponent> onDestroy) {
            this.this$0 = this$0;
            this.onDestroy = onDestroy;
            this.setReference(component);
        }

        public T getReference() {
            return this.component;
        }

        public boolean setReference(T component) {
            if (component != this.component) {
                if (component != null) {
                    ((BaseComponent)component).validatePage(this.this$0.page);
                    ((BaseComponent)component).addEventListener("destroy", (IEventListener)this);
                }
                this.removeReference();
                this.component = component;
                return true;
            }
            return false;
        }

        @Override
        public String getId() {
            return this.component == null ? null : ((BaseComponent)this.component).getId();
        }

        @Override
        public Object transformForClient() {
            if (this.component == null) {
                return null;
            }
            if (!((BaseComponent)this.component).isDead() && ((BaseComponent)this.component).getPage() == null) {
                Page page = this.this$0.page;
                ((BaseComponent)this.component)._attach(page != null ? page : ExecutionContext.getPage());
            }
            return IElementIdentifier.super.transformForClient();
        }

        public boolean equals(Object o) {
            return o instanceof ComponentReference && ((ComponentReference)o).component == this.component;
        }

        protected void finalize() {
            this.removeReference();
        }

        @Override
        public void onEvent(Event event) {
            if (this.component == event.getTarget()) {
                this.removeReference();
                if (this.onDestroy != null) {
                    this.onDestroy.accept(event.getTarget());
                }
            }
        }

        private void removeReference() {
            if (this.component != null) {
                ((BaseComponent)this.component).removeEventListener("destroy", (IEventListener)this);
                this.component = null;
            }
        }
    }

    public static class SubComponent
    implements IElementIdentifier {
        private final BaseComponent component;
        private final String subId;

        private SubComponent(BaseComponent component, String subId) {
            this.component = component;
            this.subId = subId;
        }

        @Override
        public String getId() {
            return this.component.getId() + "-" + this.subId;
        }
    }
}

