/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.component;

import org.fujion.annotation.Component;
import org.fujion.common.NumUtil;
import org.fujion.component.BaseInputComponent;

public abstract class BaseInputboxComponent<T>
extends BaseInputComponent<T> {
    private T minvalue;
    private T maxvalue;
    private String pattern;
    private String placeholder;
    private int maxLength;
    private boolean readonly;
    private boolean required;
    private boolean synced;

    protected boolean getSynchronized() {
        return this.synced;
    }

    protected void setSynchronized(boolean synced) {
        this.synced = synced;
        this.propertyChange("synced", this.synced, (Object)this.synced, true);
    }

    @Component.PropertyGetter(value="minvalue", description="The minimum allowable value, if any.")
    public T getMinValue() {
        return this.minvalue;
    }

    @Component.PropertySetter(value="minvalue", description="The minimum allowable value, if any.")
    private void _setMinValue(String minvalue) {
        this.setMinValue(this._toValue(minvalue));
    }

    public void setMinValue(T minvalue) {
        this.minvalue = minvalue;
        if (this.propertyChange("minvalue", this.minvalue, this.minvalue, false)) {
            this.sync("minvalue", this._toString(minvalue));
        }
    }

    @Component.PropertyGetter(value="maxvalue", description="The maximum allowable value, if any.")
    public T getMaxValue() {
        return this.maxvalue;
    }

    @Component.PropertySetter(value="maxvalue", description="The maximum allowable value, if any.")
    private void _setMaxValue(String maxvalue) {
        this.setMaxValue(this._toValue(maxvalue));
    }

    public void setMaxValue(T maxvalue) {
        this.maxvalue = maxvalue;
        if (this.propertyChange("maxvalue", this.maxvalue, this.maxvalue, false)) {
            this.sync("maxvalue", this._toString(maxvalue));
        }
    }

    @Component.PropertyGetter(value="pattern", description="Regular expression that constrains the input format.")
    public String getPattern() {
        return this.pattern;
    }

    @Component.PropertySetter(value="pattern", description="Regular expression that constrains the input format.")
    public void setPattern(String pattern) {
        this.pattern = this.nullify(pattern);
        this.propertyChange("pattern", this.pattern, this.pattern, true);
    }

    @Component.PropertyGetter(value="placeholder", description="The placeholder message that is displayed when the input box is empty.")
    public String getPlaceholder() {
        return this.placeholder;
    }

    @Component.PropertySetter(value="placeholder", description="The placeholder message that is displayed when the input box is empty.")
    public void setPlaceholder(String placeholder) {
        this.placeholder = this.nullify(placeholder);
        this.propertyChange("placeholder", this.placeholder, this.placeholder, true);
    }

    @Component.PropertyGetter(value="maxlength", description="The maximum character length of input.")
    public int getMaxLength() {
        return this.maxLength;
    }

    @Component.PropertySetter(value="maxlength", description="The maximum character length of input.")
    public void setMaxLength(int maxLength) {
        this.maxLength = NumUtil.enforceRange((int)maxLength, (int)0, (int)524288);
        this.propertyChange("maxlength", this.maxLength, (Object)this.maxLength, true);
    }

    @Component.PropertyGetter(value="readonly", description="True if the input box is read-only.")
    public boolean isReadonly() {
        return this.readonly;
    }

    @Component.PropertySetter(value="readonly", defaultValue="false", description="True if the input box is read-only.")
    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
        this.propertyChange("readonly", this.readonly, (Object)this.readonly, true);
    }

    @Component.PropertyGetter(value="required", description="True if input is required for this component.")
    public boolean isRequired() {
        return this.required;
    }

    @Component.PropertySetter(value="required", defaultValue="false", description="True if input is required for this component.")
    public void setRequired(boolean required) {
        this.required = required;
        this.propertyChange("required", this.required, (Object)this.required, true);
    }

    public void selectAll() {
        this.invoke("selectAll", new Object[0]);
    }

    public void selectRange(int start, int end) {
        this.invoke("selectRange", start, end);
    }
}

