/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.component;

import org.fujion.annotation.Component;
import org.fujion.component.BaseInputboxComponent;
import org.springframework.util.NumberUtils;
import org.springframework.util.StringUtils;

public abstract class BaseNumberboxComponent<T extends Number>
extends BaseInputboxComponent<T> {
    private final Class<T> clazz;
    private T step;

    protected BaseNumberboxComponent(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    @Component.PropertyGetter(value="synchronized", description="A true value means that the client will notify the server as the value of the input box changes. A false value means that the client will notify server of the new value only when the input element loses focus.")
    public boolean getSynchronized() {
        return super.getSynchronized();
    }

    @Override
    @Component.PropertySetter(value="synchronized", defaultValue="false", description="A true value means that the client will notify the server as the value of the input box changes. A false value means that the client will notify server of the new value only when the input element loses focus.")
    public void setSynchronized(boolean synchronize) {
        super.setSynchronized(synchronize);
    }

    @Component.PropertyGetter(value="step", description="The increment or decrement when the spinner element is clicked.")
    public T getStep() {
        return this.step;
    }

    @Component.PropertySetter(value="step", description="The increment or decrement when the spinner element is clicked.")
    private void _setStep(String step) {
        this.setStep(this._toValue(step));
    }

    public void setStep(T step) {
        this.step = step;
        if (this.propertyChange("step", this.step, this.step, false)) {
            this.sync("step", this._toString(step));
        }
    }

    @Override
    protected String _toString(T value) {
        return value == null ? null : value.toString();
    }

    @Override
    protected T _toValue(String value) {
        value = value == null ? "" : StringUtils.trimAllWhitespace((String)value);
        return (T)(value.isEmpty() ? (Number)null : (Number)NumberUtils.parseNumber((String)value, this.clazz));
    }
}

