/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.component;

import org.fujion.annotation.Component;
import org.fujion.common.MiscUtil;
import org.fujion.component.BaseInputboxComponent;
import org.fujion.component.BasePickerItem;
import org.fujion.model.IModelAndView;
import org.fujion.model.ISupportsModel;
import org.fujion.model.ModelAndView;

public abstract class BasePickerComponent<T, P extends BasePickerItem<T>>
extends BaseInputboxComponent<T>
implements ISupportsModel<P> {
    private final ModelAndView<P, Object> modelAndView = new ModelAndView(this);
    private boolean showText;
    private boolean showHints;
    private P converter;

    protected BasePickerComponent(Class<P> itemClass) {
        try {
            this.converter = (BasePickerItem)itemClass.newInstance();
        }
        catch (Exception e) {
            throw MiscUtil.toUnchecked((Throwable)e);
        }
    }

    @Component.PropertyGetter(value="showText", description="If true, the text representation of the selection is displayed.")
    public boolean getShowText() {
        return this.showText;
    }

    @Component.PropertySetter(value="showText", defaultValue="false", description="If true, the text representation of the selection is displayed.")
    public void setShowText(boolean showText) {
        this.showText = showText;
        this.propertyChange("showText", this.showText, (Object)this.showText, true);
    }

    @Component.PropertyGetter(value="showHints", description="If true, the text representation of pick list items is displayed when hovering over them.")
    public boolean getShowHints() {
        return this.showHints;
    }

    @Component.PropertySetter(value="showHints", defaultValue="false", description="If true, the text representation of pick list items is displayed when hovering over them.")
    public void setShowHints(boolean showHints) {
        this.showHints = showHints;
        this.propertyChange("showHints", this.showHints, (Object)this.showHints, true);
    }

    @Override
    protected T _toValue(String text) {
        return ((BasePickerItem)this.converter)._toValue(text);
    }

    @Override
    protected String _toString(T value) {
        return ((BasePickerItem)this.converter)._toString(value);
    }

    @Override
    public IModelAndView<P, ?> getModelAndView() {
        return this.modelAndView;
    }
}

