/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.component;

import java.util.HashMap;
import java.util.Map;
import org.fujion.annotation.Component;
import org.fujion.annotation.EventHandler;
import org.fujion.component.BaseComponent;
import org.fujion.component.BaseSourcedComponent;
import org.fujion.component.Page;
import org.fujion.event.EventUtil;

public abstract class BaseScriptComponent
extends BaseSourcedComponent {
    private static final String EVENT_DEFERRED = "deferredExecution";
    private final BaseComponent.ComponentReference<BaseComponent> self = new BaseComponent.ComponentReference((BaseComponent)this, (BaseComponent)this);
    private ExecutionMode mode = ExecutionMode.IMMEDIATE;
    private boolean includeNamedComponents = true;

    protected BaseScriptComponent(boolean contentSynced) {
        super(contentSynced);
    }

    protected BaseScriptComponent(String content, boolean contentSynced) {
        super(content, contentSynced);
    }

    @Component.PropertyGetter(value="mode", description="The script's execution mode.")
    public ExecutionMode getMode() {
        return this.mode;
    }

    @Component.PropertySetter(value="mode", description="The script's execution mode.")
    public void setMode(ExecutionMode mode) {
        this.mode = this.defaultify(mode, ExecutionMode.IMMEDIATE);
        this.propertyChange("mode", (Object)this.mode, (Object)this.mode, false);
    }

    public String getSelfName() {
        return "self";
    }

    @Component.PropertyGetter(value="self", description="The component to be referenced by the script language's \"self\" variable.")
    public BaseComponent getSelf() {
        return this.self.getReference();
    }

    @Component.PropertySetter(value="self", description="The component to be referenced by the script language's \"self\" variable.")
    public void setSelf(BaseComponent self) {
        BaseComponent oldSelf = this.self.getReference();
        if (oldSelf != self) {
            this.self.setReference(self);
            this.propertyChange("self", oldSelf, self, false);
        }
    }

    @Component.PropertyGetter(value="includeNamedComponents", description="If true, any named components within the namespace occupied by \"self\" will be passed as arguments to the script.")
    public boolean getIncludeNamedComponents() {
        return this.includeNamedComponents;
    }

    @Component.PropertySetter(value="includeNamedComponents", defaultValue="true", description="If true, any named components within the namespace occupied by \"self\" will be passed as arguments to the script.")
    public void setIncludeNamedComponents(boolean includeNamedComponents) {
        this.includeNamedComponents = includeNamedComponents;
    }

    public Object execute(Map<String, Object> variables) {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        BaseComponent self = this.self.getReference();
        vars.put(this.getSelfName(), self);
        if (this.includeNamedComponents && self != null) {
            vars.putAll(self.findAllNamed());
        }
        if (variables != null) {
            vars.putAll(variables);
        }
        return this._execute(vars);
    }

    public Object execute() {
        return this.execute(null);
    }

    @Override
    protected void onAttach(Page page) {
        super.onAttach(page);
        switch (this.getMode()) {
            case DEFER: {
                EventUtil.post(EVENT_DEFERRED, this, null);
                break;
            }
            case IMMEDIATE: {
                this.execute();
                break;
            }
        }
    }

    @EventHandler(value={"deferredExecution"}, syncToClient=false, mode={"init"})
    private void onDeferredExecution() {
        this.execute();
    }

    protected abstract Object _execute(Map<String, Object> var1);

    public static enum ExecutionMode {
        IMMEDIATE,
        DEFER,
        MANUAL;

    }
}

