/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.component;

import org.fujion.ancillary.CssClasses;
import org.fujion.ancillary.CssStyles;
import org.fujion.ancillary.IDisable;
import org.fujion.ancillary.PrintOptions;
import org.fujion.annotation.Component;
import org.fujion.component.BaseComponent;
import org.fujion.component.Popup;
import org.fujion.event.KeyCode;
import org.springframework.util.Assert;

public abstract class BaseUIComponent
extends BaseComponent
implements IDisable {
    private final CssStyles styles = new CssStyles();
    private final CssClasses classes = new CssClasses();
    private String height;
    private String width;
    private String flex;
    private String hint;
    private String balloon;
    private boolean disabled;
    private boolean visible = true;
    private int tabindex;
    private String css;
    private String dragid;
    private String dropid;
    private String keycapture;
    private final BaseComponent.ComponentReference<Popup> context = new BaseComponent.ComponentReference((BaseComponent)this, null, cmp -> this.propertyChange("context", cmp, null, true));
    private final BaseComponent.ComponentReference<Popup> popup = new BaseComponent.ComponentReference((BaseComponent)this, null, cmp -> this.propertyChange("popup", cmp, null, true));

    public void addMask() {
        this.addMask(null);
    }

    public void addMask(String label) {
        this.invoke("addMask", label);
    }

    public void addMask(String label, Popup popup) {
        this.invoke("addMask", label, popup);
    }

    public void removeMask() {
        this.invoke("removeMask", new Object[0]);
    }

    @Component.PropertyGetter(value="style", description="The active CSS styles for this component.")
    public String getStyles() {
        return this.styles.toString();
    }

    @Component.PropertySetter(value="style", description="The active CSS styles for this component.")
    public void setStyles(String styles) {
        String oldStyles = this.styles.toString();
        this.styles.parse(styles, true);
        this._syncStyles(oldStyles);
    }

    private String _syncStyle(String name, String dflt) {
        String current = this.styles.get(name);
        if (current != null) {
            return current;
        }
        this.styles.put(name, dflt);
        return dflt;
    }

    protected void _syncStyles(String oldStyles) {
        this.height = this._syncStyle("height", this.height);
        this.width = this._syncStyle("width", this.width);
        this.flex = this._syncStyle("flex", this.flex);
        this.propertyChange("style", oldStyles, this.styles.toString(), true);
    }

    public String getStyle(String name) {
        return this.styles.get(name);
    }

    public String addStyle(String name, String value) {
        String oldStyles = this.styles.toString();
        String oldValue = this.styles.put(name, value);
        this._syncStyles(oldStyles);
        return oldValue;
    }

    public void addStyles(String styles) {
        String oldStyles = this.styles.toString();
        this.styles.parse(styles, false);
        this._syncStyles(oldStyles);
    }

    public String removeStyle(String name) {
        return this.addStyle(name, null);
    }

    @Component.PropertyGetter(value="class", description="Space-delimited list of CSS classes.")
    public String getClasses() {
        return this.classes.toString();
    }

    public void setClasses(String classes) {
        String oldClasses = classes.toString();
        this.classes.parse(classes);
        this._syncClasses(oldClasses);
    }

    protected void _syncClasses(String oldClasses) {
        this.propertyChange("clazz", oldClasses, this.classes.toString(true), true);
    }

    @Component.PropertySetter(value="class", description="Space-delimited list of CSS classes.")
    public void addClass(String value) {
        String oldClasses = this.classes.toString();
        if (this.classes.add(value)) {
            this._syncClasses(oldClasses);
        }
    }

    public void removeClass(String value) {
        String oldClasses = this.classes.toString();
        if (this.classes.remove(value)) {
            this._syncClasses(oldClasses);
        }
    }

    public void toggleClass(String yesValue, String noValue, boolean condition) {
        String oldClasses = this.classes.toString();
        if (this.classes.toggle(yesValue, noValue, condition)) {
            this._syncClasses(oldClasses);
        }
    }

    public void hide() {
        this.setVisible(false);
    }

    public void show() {
        this.setVisible(true);
    }

    @Component.PropertyGetter(value="height", description="The component's height.")
    public String getHeight() {
        return this.height;
    }

    @Component.PropertySetter(value="height", description="The component's height.")
    public void setHeight(String height) {
        if (!this.areEqual(height = this.trimify(height), this.height)) {
            this.height = height;
            this.addStyle("height", height);
        }
    }

    @Component.PropertyGetter(value="width", description="The component's width.")
    public String getWidth() {
        return this.width;
    }

    @Component.PropertySetter(value="width", description="The component's width.")
    public void setWidth(String width) {
        if (!this.areEqual(width = this.trimify(width), this.width)) {
            this.width = width;
            this.addStyle("width", width);
        }
    }

    @Component.PropertyGetter(value="flex", description="The component's flex style setting.")
    public String getFlex() {
        return this.flex;
    }

    @Component.PropertySetter(value="flex", description="The component's flex style setting.")
    public void setFlex(String flex) {
        if (!this.areEqual(flex = this.trimify(flex), this.flex)) {
            this.flex = flex;
            this.addStyle("flex", flex);
        }
    }

    @Component.PropertySetter(value="focus", defaultValue="false", defer=true, description="Sets or removes focus for this component.")
    public void setFocus(boolean focus) {
        this.invoke("focus", focus);
    }

    public void focus() {
        this.setFocus(true);
    }

    @Component.PropertyGetter(value="css", description="The CSS specifier for this component.")
    public String getCss() {
        return this.css;
    }

    @Component.PropertySetter(value="css", description="The CSS specifier for this component.")
    public void setCss(String css) {
        this.css = this.nullify(css);
        this.propertyChange("css", this.css, this.css, true);
    }

    public void reportSize() {
        this.invoke("reportSize", new Object[0]);
    }

    @Component.PropertyGetter(value="hint", description="The popup text to be displayed when hovering over this component.")
    public String getHint() {
        return this.hint;
    }

    @Component.PropertySetter(value="hint", description="The popup text to be displayed when hovering over this component.")
    public void setHint(String hint) {
        this.hint = this.nullify(hint);
        this.propertyChange("hint", this.hint, this.hint, true);
    }

    @Component.PropertyGetter(value="balloon", description="The balloon text to be displayed adjacent to the component.")
    public String getBalloon() {
        return this.balloon;
    }

    @Component.PropertySetter(value="balloon", description="The balloon text to be displayed adjacent to the component.")
    public void setBalloon(String balloon) {
        this.balloon = this.nullify(balloon);
        this.propertyChange("balloon", this.balloon, this.balloon, true);
    }

    @Override
    @Component.PropertyGetter(value="disabled", description="True if the component is disabled.")
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    @Component.PropertySetter(value="disabled", defaultValue="false", description="True if the component is disabled.")
    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
        this.propertyChange("disabled", this.disabled, (Object)this.disabled, true);
    }

    @Component.PropertyGetter(value="visible", description="The visibility state of the component.")
    public boolean isVisible() {
        return this.visible;
    }

    @Component.PropertySetter(value="visible", defaultValue="true", description="The visibility state of the component.")
    public void setVisible(boolean visible) {
        this.visible = visible;
        this.propertyChange("visible", this.visible, (Object)this.visible, true);
    }

    @Component.PropertyGetter(value="tabindex", description="The tab index for the component.")
    public int getTabindex() {
        return this.tabindex;
    }

    @Component.PropertySetter(value="tabindex", defaultValue="0", description="The tab index for the component.")
    public void setTabindex(int tabindex) {
        this.tabindex = tabindex < 0 ? 0 : tabindex;
        this.propertyChange("tabindex", this.tabindex, (Object)this.tabindex, true);
    }

    @Component.PropertyGetter(value="dragid", description="A space-delimited list of drag id's associated with this component.")
    public String getDragid() {
        return this.dragid;
    }

    @Component.PropertySetter(value="dragid", description="A space-delimited list of drag id's associated with this component.")
    public void setDragid(String dragid) {
        this.dragid = this.trimify(dragid);
        this.propertyChange("dragid", this.dragid, this.dragid, true);
    }

    @Component.PropertyGetter(value="dropid", description="A space-delimited list of drop id's associated with this component.")
    public String getDropid() {
        return this.dropid;
    }

    @Component.PropertySetter(value="dropid", description="A space-delimited list of drop id's associated with this component.")
    public void setDropid(String dropid) {
        this.dropid = this.trimify(dropid);
        this.propertyChange("dropid", this.dropid, this.dropid, true);
    }

    @Component.PropertyGetter(value="context", description="The popup component that will appear when right-clicking on this component.")
    public Popup getContext() {
        return this.context == null ? null : this.context.getReference();
    }

    @Component.PropertySetter(value="context", defer=true, description="The popup component that will appear when right-clicking on this component.")
    public void setContext(Popup context) {
        this.propertyChange("context", this.context, context, true);
    }

    @Component.PropertyGetter(value="popup", description="The popup component that will appear when hovering over this component.")
    public Popup getPopup() {
        return this.popup == null ? null : this.popup.getReference();
    }

    @Component.PropertySetter(value="popup", defer=true, description="The popup component that will appear when hovering over this component.")
    public void setPopup(Popup popup) {
        this.propertyChange("popup", this.popup, popup, true);
    }

    @Override
    protected void afterRemoveChild(BaseComponent child) {
        super.afterRemoveChild(child);
        if (child == this.popup.getReference()) {
            this.setPopup(null);
        }
    }

    @Component.PropertyGetter(value="keycapture", description="The list of key codes to be captured.")
    public String getKeycapture() {
        return this.keycapture;
    }

    @Component.PropertySetter(value="keycapture", description="The list of key codes to be captured.")
    public void setKeycapture(String keycapture) {
        this.keycapture = this.nullify(keycapture);
        if (this.propertyChange("keycapture", this.keycapture, this.keycapture, false)) {
            this.sync("keycapture", KeyCode.normalizeKeyCapture(this.keycapture));
        }
    }

    public void scrollIntoView() {
        this.invoke("scrollIntoView", new Object[0]);
    }

    public BaseUIComponent getFirstVisibleChild(boolean recurse) {
        return this.getFirstVisibleChild(BaseUIComponent.class, recurse);
    }

    public <T extends BaseUIComponent> T getFirstVisibleChild(Class<T> clazz, boolean recurse) {
        for (BaseUIComponent child : this.getChildren(clazz)) {
            if (!child.isVisible()) continue;
            return (T)child;
        }
        if (recurse) {
            for (BaseUIComponent child : this.getChildren(clazz)) {
                T comp = child.getFirstVisibleChild(clazz, recurse);
                if (comp == null) continue;
                return comp;
            }
        }
        return null;
    }

    public void print() {
        this.print(null);
    }

    public void print(PrintOptions options) {
        Assert.state((boolean)this.isRendered(), () -> "A component may not be printed if it has not yet been rendered");
        this.invoke("print", options);
    }
}

