/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.component;

import org.fujion.annotation.Component;
import org.fujion.component.BaseComponent;
import org.fujion.component.BaseInputboxComponent;
import org.fujion.component.Comboitem;
import org.fujion.model.IModelAndView;
import org.fujion.model.ISupportsModel;
import org.fujion.model.ModelAndView;

@Component(tag="combobox", widgetClass="Combobox", parentTag={"*"}, childTag={@Component.ChildTag(value="comboitem")}, description="A combo box control.")
public class Combobox
extends BaseInputboxComponent<String>
implements ISupportsModel<Comboitem> {
    private Comboitem selected;
    private boolean autoFilter;
    private final ModelAndView<Comboitem, Object> modelAndView = new ModelAndView(this);

    public Comboitem getSelectedItem() {
        return this.selected;
    }

    public void setSelectedItem(Comboitem item) {
        this.validateIsChild(item);
        if (item == null) {
            this._updateSelected(item);
        } else {
            item.setSelected(true);
        }
    }

    public int getSelectedIndex() {
        Comboitem item = this.getSelectedItem();
        return item == null ? -1 : item.getIndex();
    }

    public void setSelectedIndex(int index) {
        this.setSelectedItem((Comboitem)this.getChildAt(index));
    }

    protected void _updateSelected(Comboitem item) {
        if (this.selected != null) {
            this.selected._setSelected(false, true, false);
        }
        this.selected = item;
        this.setValue(this.selected == null ? null : this.selected.getLabel());
    }

    @Override
    protected void afterAddChild(BaseComponent child) {
        Comboitem item = (Comboitem)child;
        if (item.isSelected()) {
            this._updateSelected(item);
        }
    }

    @Override
    protected void afterRemoveChild(BaseComponent child) {
        if (child == this.selected) {
            this.selected = null;
        }
    }

    @Component.PropertyGetter(value="autoFilter", description="True if any choices not matching the current input should be hidden.")
    public boolean getAutoFilter() {
        return this.autoFilter;
    }

    @Component.PropertySetter(value="autoFilter", defaultValue="false", description="True if any choices not matching the current input should be hidden.")
    public void setAutoFilter(boolean autoFilter) {
        this.autoFilter = autoFilter;
        this.propertyChange("autoFilter", this.autoFilter, (Object)this.autoFilter, true);
    }

    @Override
    protected String _toValue(String value) {
        return value;
    }

    @Override
    protected String _toString(String value) {
        return value;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.modelAndView.destroy();
    }

    @Override
    public IModelAndView<Comboitem, ?> getModelAndView() {
        return this.modelAndView;
    }
}

