/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.component;

import org.fujion.ancillary.ComponentException;
import org.fujion.annotation.Component;
import org.fujion.annotation.EventHandler;
import org.fujion.component.BaseComponent;
import org.fujion.component.BaseLabeledComponent;
import org.fujion.event.ChangeEvent;
import org.fujion.model.IPaginator;
import org.fujion.model.ISupportsModel;

@Component(tag="paging", widgetClass="Paging", parentTag={"*"}, description="A page navigation component.")
public class Paging
extends BaseLabeledComponent<BaseLabeledComponent.LabelPositionNone> {
    private IPaginator paginator;
    private int currentPage;
    private int pageSize;
    private int maxPage;
    private boolean fromPaginator;
    private final IPaginator.IPagingListener pagingListener = (type, oldValue, newValue) -> {
        try {
            this.fromPaginator = true;
            switch (type) {
                case CURRENT_PAGE: {
                    this.setCurrentPage(newValue);
                    return;
                }
                case PAGE_SIZE: {
                    this.setPageSize(newValue);
                    return;
                }
                case MAX_PAGE: {
                    this.setMaxPage(newValue);
                    return;
                }
            }
            return;
        }
        finally {
            this.fromPaginator = false;
        }
    };

    public Paging() {
    }

    public Paging(String label) {
        super(label);
    }

    public IPaginator getPaginator() {
        return this.paginator;
    }

    public void setPaginator(IPaginator paginator) {
        if (paginator != this.paginator) {
            if (this.paginator != null) {
                this.paginator.removeEventListener(this.pagingListener);
            }
            this.paginator = paginator;
            this.setMaxPage(paginator == null ? 0 : paginator.getMaxPage());
            this.syncToPaginator();
        }
    }

    @Component.PropertyGetter(value="currentPage", description="The number of the currently selected page.")
    public int getCurrentPage() {
        return this.currentPage;
    }

    @Component.PropertySetter(value="currentPage", defaultValue="0", description="The number of the currently selected page.")
    public void setCurrentPage(int currentPage) {
        this._setCurrentPage(currentPage, true);
    }

    private void _setCurrentPage(int currentPage, boolean notifyClient) {
        this.currentPage = currentPage;
        if (this.propertyChange("currentPage", this.currentPage, (Object)this.currentPage, notifyClient)) {
            this.syncToPaginator();
        }
    }

    @Component.PropertyGetter(value="pageSize", description="The maximum number of items on a single page.")
    public int getPageSize() {
        return this.pageSize;
    }

    @Component.PropertySetter(value="pageSize", description="The maximum number of items on a single page.")
    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
        if (this.propertyChange("pageSize", this.pageSize, (Object)this.pageSize, true)) {
            this.syncToPaginator();
        }
    }

    @Component.PropertySetter(value="target", defer=true, description="The component whose associated model will be manipulated by paging operations.")
    private void setPagingTarget(BaseComponent comp) {
        if (comp == null) {
            this.setPaginator(null);
        } else if (comp instanceof ISupportsModel) {
            this.setPaginator(((ISupportsModel)((Object)comp)).getPaginator());
        } else {
            throw new ComponentException(comp, "Paging target does not support model", new Object[0]);
        }
    }

    private void setMaxPage(int maxPage) {
        this.maxPage = maxPage;
        this.propertyChange("maxPage", this.maxPage, (Object)this.maxPage, true);
    }

    private void syncToPaginator() {
        if (this.paginator != null && !this.fromPaginator) {
            this.paginator.removeEventListener(this.pagingListener);
            this.paginator.setPageSize(this.pageSize);
            this.paginator.setCurrentPage(this.currentPage);
            this.paginator.addEventListener(this.pagingListener);
        }
    }

    @EventHandler(value={"change"}, syncToClient=false, mode={"init"})
    private void _onChange(ChangeEvent event) {
        this._setCurrentPage(this.defaultify(event.getValue(Integer.class), this.currentPage), false);
    }
}

