/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.component;

import org.fujion.annotation.Component;
import org.fujion.component.BaseComponent;
import org.fujion.component.BaseUIComponent;
import org.fujion.component.Radiobutton;

@Component(tag="radiogroup", widgetClass="Radiogroup", content=Component.ContentHandling.AS_CHILD, parentTag={"*"}, childTag={@Component.ChildTag(value="*")}, description="Logically groups together multiple radio buttons.")
public class Radiogroup
extends BaseUIComponent {
    private Orientation orientation = Orientation.HORIZONTAL;

    public Radiobutton getSelected() {
        return this.getSelected(this);
    }

    private Radiobutton getSelected(BaseComponent parent) {
        for (Radiobutton radiobutton : parent.getChildren(Radiobutton.class)) {
            if (!radiobutton.isChecked()) continue;
            return radiobutton;
        }
        for (BaseComponent baseComponent : parent.getChildren()) {
            Radiobutton rb = baseComponent instanceof Radiogroup ? null : this.getSelected(baseComponent);
            if (rb == null) continue;
            return rb;
        }
        return null;
    }

    @Component.PropertyGetter(value="orientation", description="The orientation of radio buttons belonging to this group.")
    public Orientation getOrientation() {
        return this.orientation;
    }

    @Component.PropertySetter(value="orientation", defaultValue="horizontal", description="The orientation of radio buttons belonging to this group.")
    public void setOrientation(Orientation orientation) {
        this.orientation = this.defaultify(orientation, Orientation.HORIZONTAL);
        this.propertyChange("orientation", (Object)this.orientation, (Object)this.orientation, true);
    }

    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }
}

